/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.groups.tasks;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.wrappers.TransactionWrapper;
import io.olvid.windows.messenger.engine.helpers.discussion.DiscussionApi;
import io.olvid.windows.messenger.engine.helpers.message.MessageHelper;
import io.olvid.windows.messenger.engine.helpers.message.MessageInsertionHelper;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.Optional;

public class GroupV2DeletedNotificationHandler
implements Runnable {
    final OwnedIdentity ownedIdentity;
    final byte[] bytesGroupIdentifier;

    public GroupV2DeletedNotificationHandler(OwnedIdentity ownedIdentity, byte[] bytesGroupIdentifier) {
        this.ownedIdentity = ownedIdentity;
        this.bytesGroupIdentifier = bytesGroupIdentifier;
    }

    @Override
    public void run() {
        Group group = DbManager.getInstance().getGroupDao().get(this.ownedIdentity, this.bytesGroupIdentifier);
        if (group != null) {
            try {
                TransactionWrapper.startStatementTransaction(() -> {
                    Discussion discussion = DbManager.getInstance().getDiscussionDao().get(group);
                    if (discussion != null) {
                        Optional<Long> messagesCountOpt = MessageHelper.countUserMessagesInDiscussion(discussion);
                        if (messagesCountOpt.isPresent() && messagesCountOpt.get() == 0L) {
                            if (DbManager.getInstance().getDiscussionDao().delete(discussion) <= 0) {
                                throw new SQLException("Cannot delete discussion");
                            }
                        } else {
                            DiscussionApi.lockDiscussion(discussion);
                            if (DbManager.getInstance().getDiscussionDao().update(discussion) <= 0) {
                                throw new SQLException("Cannot update discussion");
                            }
                            MessageInsertionHelper.insertLeftGroupMessage(discussion);
                        }
                    }
                    DbManager.getInstance().getGroupDao().delete(group);
                    return null;
                });
            }
            catch (SQLException e) {
                AppLogger.e("GroupV2DeletedNotificationHandler::run error in transaction", e);
            }
        }
    }
}

