/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.files;

import io.olvid.engine.secure_io.SecureFile;
import io.olvid.engine.secure_io.SecureFileOutputStream;
import io.olvid.windows.messenger.engine.helpers.files.FileApi;
import io.olvid.windows.messenger.logger.AppLogger;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Consumer;
import javax.imageio.ImageIO;

class ImageHelper {
    static final int PROFILE_PHOTO_WITH = 1080;
    static final int PROFILE_PHOTO_HEIGHT = 1080;

    ImageHelper() {
    }

    private static String determineFileFormat(String fileName) throws Exception {
        if (fileName.lastIndexOf(".") == -1) {
            throw new Exception("ImageCompressor: determineFileFormat: Unable to determine file format");
        }
        return fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
    }

    static boolean isImage(String fileName) throws Exception {
        String fileFormat = ImageHelper.determineFileFormat(fileName);
        return fileFormat.equals("jpg") || fileFormat.equals("jpeg") || fileFormat.equals("png");
    }

    static void _resizeCompressAndEncryptImageTask(String originalAbsoluteFilePath, String destinationRelativeFilePath, int width, int height, Consumer<String> onSuccess, Consumer<Exception> onError) {
        block4: {
            try {
                File originalFile = new File(originalAbsoluteFilePath);
                if (!originalFile.exists()) {
                    throw new FileNotFoundException("File not found: " + originalAbsoluteFilePath);
                }
                String fileFormat = ImageHelper.determineFileFormat(originalFile.getName());
                BufferedImage croppedAndResizedImage = ImageHelper.resizeAndCompressImage(new FileInputStream(originalFile), width, height);
                AppLogger.d("SecureFilePath: " + destinationRelativeFilePath);
                SecureFileOutputStream secureFileOutputStream = new SecureFileOutputStream(new SecureFile(FileApi.absolutePathFromRelative(destinationRelativeFilePath)));
                ImageIO.write((RenderedImage)croppedAndResizedImage, fileFormat, (OutputStream)secureFileOutputStream);
                secureFileOutputStream.close();
                if (onSuccess != null) {
                    onSuccess.accept(destinationRelativeFilePath);
                }
            }
            catch (Exception e) {
                AppLogger.e("ResizeCompressAndEncryptImageTask: unable to process", e);
                if (onError == null) break block4;
                onError.accept(e);
            }
        }
    }

    static BufferedImage resizeAndCompressImage(InputStream originalFileInputStream, int width, int heigth) throws Exception {
        long startTime = System.nanoTime();
        BufferedImage inputImage = ImageIO.read(originalFileInputStream);
        originalFileInputStream.close();
        long endTime = System.nanoTime();
        long duration = endTime - startTime;
        AppLogger.d("ImageIO.read took ---> " + duration / 1000000L);
        int size = Math.min(inputImage.getWidth(), inputImage.getHeight());
        int widthScale = Math.min(size, width);
        int heightScale = Math.min(size, heigth);
        startTime = System.nanoTime();
        BufferedImage croppedImage = new BufferedImage(size, size, inputImage.getType());
        endTime = System.nanoTime();
        duration = endTime - startTime;
        AppLogger.d("new BufferedImage took ---> " + duration / 1000000L);
        startTime = System.nanoTime();
        Graphics2D g2d = croppedImage.createGraphics();
        endTime = System.nanoTime();
        duration = endTime - startTime;
        AppLogger.d("createGraphics took ---> " + duration / 1000000L);
        int x = (inputImage.getWidth() - size) / 2;
        int y = (inputImage.getHeight() - size) / 2;
        endTime = System.nanoTime();
        duration = endTime - startTime;
        AppLogger.d("new BufferedImage took ---> " + duration / 1000000L);
        long startTimeIn = System.nanoTime();
        g2d.drawImage(inputImage, 0, 0, size, size, x, y, x + size, y + size, (img, infoflags, x1, y1, width1, height) -> {
            long endTimeIn = System.nanoTime();
            long durationIn = endTimeIn - startTimeIn;
            AppLogger.d("drawImage INN ANN took ---> " + durationIn / 1000000L);
            return true;
        });
        endTime = System.nanoTime();
        duration = endTime - startTime;
        AppLogger.d("drawImage took ---> " + duration / 1000000L);
        g2d.dispose();
        startTime = System.nanoTime();
        BufferedImage compressedImage = new BufferedImage(widthScale, heightScale, inputImage.getType());
        endTime = System.nanoTime();
        duration = endTime - startTime;
        AppLogger.d(" new BufferedImage1 took ---> " + duration / 1000000L);
        startTime = System.nanoTime();
        Image tmpImage = croppedImage.getScaledInstance(widthScale, heightScale, 4);
        endTime = System.nanoTime();
        duration = endTime - startTime;
        AppLogger.d("getScaledInstance took ---> " + duration / 1000000L);
        startTime = System.nanoTime();
        g2d = compressedImage.createGraphics();
        endTime = System.nanoTime();
        duration = endTime - startTime;
        AppLogger.d("createGraphics1 took ---> " + duration / 1000000L);
        long startTimeIN = System.nanoTime();
        g2d.drawImage(tmpImage, 0, 0, widthScale, heightScale, (img, infoflags, x1, y1, width1, height) -> {
            long endTimeIn = System.nanoTime();
            long durationIn = endTimeIn - startTimeIN;
            AppLogger.d("drawImage INN ANN took ---> " + durationIn / 1000000L);
            return true;
        });
        endTime = System.nanoTime();
        duration = endTime - startTime;
        AppLogger.d("drawImage1 took ---> " + duration / 1000000L);
        g2d.dispose();
        return compressedImage;
    }

    static boolean deleteCustomPhotoTask(String relativePhotoPath) {
        SecureFile thumbnailSecureFile = new SecureFile(FileApi.absolutePathFromRelative(relativePhotoPath));
        if (thumbnailSecureFile.exists()) {
            try {
                thumbnailSecureFile.delete();
            }
            catch (IOException ioException) {
                AppLogger.e("ImageHelper: deleteCustomPhoto: unable to delete image");
                return false;
            }
            return true;
        }
        AppLogger.i("ImageHelper: deleteCustomPhoto: file not found");
        return false;
    }
}

