/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.files;

import io.olvid.windows.messenger.database.tables.Fyle;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.engine.helpers.files.FileHelper;
import io.olvid.windows.messenger.engine.helpers.files.FileLocker;
import io.olvid.windows.messenger.engine.helpers.files.FyleHelper;
import io.olvid.windows.messenger.engine.helpers.files.ImageHelper;
import io.olvid.windows.messenger.engine.helpers.files.SizeAndSha256;
import io.olvid.windows.messenger.engine.helpers.files.ThumbnailHelper;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;

public class FileApi {
    public static final String TMP_DIRECTORY = "tmp";
    public static final String FYLE_DIRECTORY = "fyles";
    public static final String THUMBNAIL_DIRECTORY = "thumbnails";
    public static final int PROFILE_PHOTO_WIDTH = 1080;
    public static final int PROFILE_PHOTO_HEIGHT = 1080;
    public static final int THUMBNAIL_HEIGHT = 25;
    public static final double THUMBNAIL_WIDTH = 25.0;

    public static String _getRandomTemporaryRelativePath() {
        return FileHelper.getRandomTemporaryRelativePath();
    }

    public static String absolutePathFromRelative(String relativePath) {
        return FileHelper.absolutePathFromRelative(relativePath);
    }

    public static void _moveFile(String newRelativePath, String oldRelativePath) throws IOException {
        FileHelper._moveFile(newRelativePath, oldRelativePath);
    }

    public static SizeAndSha256 _computeSHA256FromUnencryptedFile(String absoluteFilePath) {
        return FileHelper._computeSHA256FromUnencryptedFile(absoluteFilePath);
    }

    public static SizeAndSha256 _computeSHA256FromEncryptedFile(String relativeFilePath) {
        return FileHelper._computeSHA256FromEncryptedFile(relativeFilePath);
    }

    public static void _resizeCompressAndEncryptImageTask(String originalAbsoluteFilePath, int width, int height, Consumer<String> onSuccess, Consumer<Exception> onError) {
        ImageHelper._resizeCompressAndEncryptImageTask(originalAbsoluteFilePath, FileApi._getRandomTemporaryRelativePath(), width, height, onSuccess, onError);
    }

    public static boolean _deleteCustomImageTask(String relativeImagePath) {
        return ImageHelper.deleteCustomPhotoTask(relativeImagePath);
    }

    public static boolean isImage(String fileName) throws Exception {
        return ImageHelper.isImage(fileName);
    }

    public static void _deleteFyleIfOrphanTask(Id<Fyle> fyle) {
        FyleHelper.deleteFyleIfOrphanTask(fyle);
    }

    public static void _deleteFylesIfOrphansTask(Iterable<Id<Fyle>> fyles) {
        for (Id<Fyle> fyleId : fyles) {
            FyleHelper.deleteFyleIfOrphanTask(fyleId);
        }
    }

    public static void _deleteFyleTask(Id<Fyle> fyle) {
        FyleHelper.deleteFyleTask(fyle);
    }

    public static void _acquireLock(String filepath) {
        FileLocker.acquireLock(filepath);
    }

    public static void _releaseLock(String filepath) {
        FileLocker.releaseLock(filepath);
    }

    public static boolean isDefaultThumbnail(String thumbnailPath) {
        return ThumbnailHelper.isDefaultThumbnail(thumbnailPath);
    }

    public static String getDefaultThumbnailByMime(String mimeType) {
        return ThumbnailHelper.getDefaultThumbnailByMime(mimeType);
    }

    public static void _deleteThumbnailFiles(List<String> thumbnailPaths) {
        for (String thumbnailPath : thumbnailPaths) {
            ThumbnailHelper.deleteThumbnailFile(thumbnailPath);
        }
    }

    public static void _deleteThumbnailFile(String thumbnailPath) {
        ThumbnailHelper.deleteThumbnailFile(thumbnailPath);
    }
}

