/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.helpers.discussion;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.DiscussionCustomization;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.PreContact;
import io.olvid.windows.messenger.database.tables.PreGroup;
import io.olvid.windows.messenger.database.tables.gen.DiscussionGenerated;
import io.olvid.windows.messenger.engine.helpers.message.MessageBuilder;
import io.olvid.windows.messenger.engine.helpers.message.MessageInsertionHelper;
import io.olvid.windows.messenger.engine.helpers.standalone_interfaces.DiscussionCustomizationApi;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class DiscussionCreationHelper {
    public static Discussion createOrReuseOneToOneDiscussionDbTask(@NotNull Contact contact) throws SQLException {
        Discussion discussion = DbManager.getInstance().getDiscussionDao().getDiscussionByIdentifier(contact.getOwnedIdentityId(), contact.getBytesContactIdentity());
        OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(contact.getOwnedIdentityId());
        if (ownedIdentity == null) {
            throw new IllegalStateException("OwnedIdentity not found");
        }
        if (discussion == null) {
            discussion = new Discussion(contact.getBytesContactIdentity(), ownedIdentity, DiscussionGenerated.Status.NORMAL, contact);
            discussion = DbManager.getInstance().getDiscussionDao().createIfNotExists(discussion);
            if (discussion == null) {
                throw new SQLException("Cannot insert Discussion in db");
            }
            DiscussionCustomization discussionCustomization = DiscussionCustomization.createDiscussionCustomizationFromDefaultValues(discussion);
            discussionCustomization = DbManager.getInstance().getDiscussionCustomizationDao().createIfNotExists(discussionCustomization);
            if (discussionCustomization == null) {
                throw new SQLException("Cannot insert DiscussionCustomization in db");
            }
        } else if (discussion.isLocked() || discussion.isPreDiscussion()) {
            if (discussion.isLocked()) {
                discussion.setLockedTitle(Optional.empty());
            } else if (discussion.isPreDiscussion()) {
                discussion.setPreContact(Optional.empty());
            }
            discussion.setContact(Optional.of(contact));
            discussion.setStatus(DiscussionGenerated.Status.NORMAL);
            discussion.setSortTimestamp(System.currentTimeMillis());
            if (DbManager.getInstance().getDiscussionDao().update(discussion) <= 0) {
                throw new SQLException("Cannot update existing discussion");
            }
        }
        return discussion;
    }

    public static Discussion createOrReuseOneToOneDiscussionDbTask(@NotNull PreContact preContact) throws SQLException {
        ContactRef contactRef = DbManager.getInstance().getContactRefDao().get(preContact.getContactRefId());
        OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(contactRef.getOwnedIdentityId());
        if (ownedIdentity == null) {
            throw new SQLException("OwnedIdentity not found");
        }
        Discussion discussion = DbManager.getInstance().getDiscussionDao().getDiscussionByIdentifier(contactRef.getOwnedIdentityId(), contactRef.getBytesContactIdentity());
        if (discussion == null) {
            discussion = new Discussion(contactRef.getBytesContactIdentity(), ownedIdentity, DiscussionGenerated.Status.PRE_DISCUSSION, preContact);
            discussion = DbManager.getInstance().getDiscussionDao().createIfNotExists(discussion);
            if (discussion == null) {
                throw new SQLException("Cannot insert Discussion in db");
            }
            DiscussionCustomization discussionCustomization = DiscussionCustomization.createDiscussionCustomizationFromDefaultValues(discussion);
            discussionCustomization = DbManager.getInstance().getDiscussionCustomizationDao().createIfNotExists(discussionCustomization);
            if (discussionCustomization == null) {
                throw new SQLException("Cannot insert DiscussionCustomization in db");
            }
        } else if (discussion.isLocked() || discussion.isHidden()) {
            if (discussion.isLocked()) {
                discussion.setLockedTitle(Optional.empty());
            }
            discussion.setPreContact(Optional.of(preContact));
            discussion.setStatus(DiscussionGenerated.Status.PRE_DISCUSSION);
            discussion.setSortTimestamp(System.currentTimeMillis());
            if (DbManager.getInstance().getDiscussionDao().update(discussion) <= 0) {
                throw new SQLException("Cannot update existing discussion");
            }
        } else if (!discussion.isPreDiscussion()) {
            AppLogger.e("DiscussionCreationHelper: preContact: cannot re-use a normal discussion");
            throw new SQLException("Cannot pass a normal discussion to pre discussion");
        }
        return discussion;
    }

    public static Discussion createOrReuseGroupDiscussionDbTask(Group group) throws SQLException {
        OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(group.getOwnedIdentityId());
        if (ownedIdentity == null) {
            throw new IllegalStateException("OwnedIdentity not found");
        }
        Discussion discussion = DbManager.getInstance().getDiscussionDao().getDiscussionByIdentifier((Id<OwnedIdentity>)ownedIdentity.getItemId(), group.getBytesGroupIdentifier());
        if (discussion == null) {
            discussion = new Discussion(group.getBytesGroupIdentifier(), ownedIdentity, DiscussionGenerated.Status.NORMAL, group);
            discussion = DbManager.getInstance().getDiscussionDao().createIfNotExists(discussion);
            if (discussion == null) {
                throw new SQLException("Cannot insert Discussion in db");
            }
            DiscussionCustomization discussionCustomization = DiscussionCustomization.createDiscussionCustomizationFromDefaultValues(discussion);
            discussionCustomization = DbManager.getInstance().getDiscussionCustomizationDao().createIfNotExists(discussionCustomization);
            if (discussionCustomization == null) {
                throw new SQLException("Cannot insert DiscussionCustomization in db");
            }
        } else if (discussion.isLocked() || discussion.isPreDiscussion()) {
            if (discussion.isLocked()) {
                discussion.setLockedTitle(Optional.empty());
            } else if (discussion.isPreDiscussion()) {
                discussion.setPreGroup(Optional.empty());
            }
            DiscussionCustomization discussionCustomization = DbManager.getInstance().getDiscussionCustomizationDao().getDiscussionCustomization((Id<Discussion>)discussion.getItemId());
            if (discussionCustomization == null) {
                throw new SQLException("Cannot found DiscussionCustomization for " + String.valueOf(discussion.getItemId()));
            }
            if (!DiscussionCustomizationApi.areSharedPreferencesDefaultValues(discussionCustomization)) {
                IdentityRef ownedIdentityRef = DbManager.getInstance().getIdentityRefDao().getOrCreateOwnedIdentityRef((Id<OwnedIdentity>)ownedIdentity.getItemId());
                MessageInsertionHelper.insertDiscussionSettingsUpdateMessageDbTask(discussion, discussionCustomization.getSharedSettingsJson().getJsonExpiration(), ownedIdentityRef, System.currentTimeMillis(), MessageBuilder.MessageSystemPosition.MESSAGE_TIMESTAMP);
            }
            discussion.setGroup(Optional.of(group));
            discussion.setSortTimestamp(System.currentTimeMillis());
            discussion.setStatus(DiscussionGenerated.Status.NORMAL);
            if (DbManager.getInstance().getDiscussionDao().update(discussion) < 1) {
                throw new SQLException("Cannot update Discussion in db");
            }
        }
        return discussion;
    }

    public static Discussion createOrReusePreGroupDiscussionDbTask(PreGroup preGroup) throws SQLException {
        OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(preGroup.getOwnedIdentityId());
        if (ownedIdentity == null) {
            throw new IllegalStateException("OwnedIdentity not found");
        }
        Discussion discussion = DbManager.getInstance().getDiscussionDao().getDiscussionByIdentifier((Id<OwnedIdentity>)ownedIdentity.getItemId(), preGroup.getBytesGroupIdentifier());
        if (discussion == null) {
            discussion = new Discussion(preGroup.getBytesGroupIdentifier(), ownedIdentity, DiscussionGenerated.Status.PRE_DISCUSSION, preGroup);
            discussion = DbManager.getInstance().getDiscussionDao().createIfNotExists(discussion);
            if (discussion == null) {
                throw new SQLException("Cannot insert Discussion in db");
            }
            DiscussionCustomization discussionCustomization = DiscussionCustomization.createDiscussionCustomizationFromDefaultValues(discussion);
            discussionCustomization = DbManager.getInstance().getDiscussionCustomizationDao().createIfNotExists(discussionCustomization);
            if (discussionCustomization == null) {
                throw new SQLException("Cannot insert DiscussionCustomization in db");
            }
        } else if (discussion.isLocked()) {
            discussion.setLockedTitle(Optional.empty());
            discussion.setPreGroup(Optional.of(preGroup));
            discussion.setSortTimestamp(System.currentTimeMillis());
            discussion.setStatus(DiscussionGenerated.Status.PRE_DISCUSSION);
            if (DbManager.getInstance().getDiscussionDao().update(discussion) < 1) {
                throw new SQLException("Cannot update Discussion in db");
            }
        } else if (!discussion.isPreDiscussion()) {
            AppLogger.e("DiscussionCreationHelper: preGroup: cannot re-use a normal discussion");
            throw new SQLException("Cannot pass a normal discussion to pre discussion");
        }
        return discussion;
    }
}

