/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.attachment.tasks;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Fyle;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.gen.attachment.AbstractAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.database.wrappers.TransactionWrapper;
import io.olvid.windows.messenger.engine.helpers.files.FileApi;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class DeleteDraftAttachmentsDbTask
implements Runnable {
    private final List<OutboundAttachment> draftAttachments;

    public DeleteDraftAttachmentsDbTask(List<OutboundAttachment> draftAttachments) {
        this.draftAttachments = draftAttachments;
    }

    public DeleteDraftAttachmentsDbTask(OutboundAttachment attachment) {
        this.draftAttachments = Collections.singletonList(attachment);
    }

    @Override
    public void run() {
        if (this.draftAttachments == null || this.draftAttachments.isEmpty()) {
            AppLogger.d("AttachmentService: deleteAttachmentsDbTask: no draftAttachments");
            return;
        }
        List draftAttachmentIds = this.draftAttachments.stream().map(AbstractTableGenerated::getItemId).toList();
        List draftAttachments = DbManager.getInstance().getOutboundAttachmentDao().get(draftAttachmentIds);
        if (draftAttachments == null || draftAttachments.isEmpty()) {
            AppLogger.e("AttachmentService: deleteAttachmentsDbTask: unable to refresh draftAttachments in db");
            return;
        }
        try {
            TransactionWrapper.startStatementTransaction(() -> {
                if (DbManager.getInstance().getOutboundAttachmentDao().deleteIds(draftAttachmentIds) < draftAttachmentIds.size()) {
                    throw new Exception("Unable to delete all draftAttachments in db");
                }
                Set<Id<Fyle>> fylesSet = draftAttachments.stream().map(AbstractAttachmentGenerated::getFyleId).collect(Collectors.toSet());
                FileApi._deleteFylesIfOrphansTask(fylesSet);
                return null;
            });
        }
        catch (SQLException e) {
            AppLogger.e("AttachmentService: deleteAttachmentsDbTask: Unable to finish transaction, rolling back", e);
            return;
        }
        Set thumbnailPaths = draftAttachments.stream().map(AbstractAttachmentGenerated::getThumbnailPath).collect(Collectors.toSet());
        FileApi._deleteThumbnailFiles(thumbnailPaths.stream().toList());
    }
}

