/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.attachment.tasks;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.attachment.AttachmentRecipientInfo;
import io.olvid.windows.messenger.database.tables.attachment.InboundAttachment;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.attachment.OwnedAttachment;
import io.olvid.windows.messenger.database.tables.gen.attachment.AbstractAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.attachment.ReceivedAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.database.wrappers.TransactionWrapper;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.engine.helpers.files.FileApi;
import io.olvid.windows.messenger.livedata.cache.AttachmentProgressCache;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class DeleteAttachmentsDbTask
implements Runnable {
    List<ReceivedAttachmentGenerated<?>> receivedAttachments = new ArrayList();
    List<OutboundAttachment> outboundAttachments = new ArrayList<OutboundAttachment>();

    public DeleteAttachmentsDbTask(List<? extends AbstractUserMessageGenerated<?>> messages) {
        this.build(messages);
    }

    public DeleteAttachmentsDbTask(AbstractUserMessageGenerated<?> messages) {
        List<AbstractUserMessageGenerated<?>> messagesWithAttachment = Collections.singletonList(messages);
        this.build(messagesWithAttachment);
    }

    public DeleteAttachmentsDbTask(ReceivedAttachmentGenerated<?> attachment) {
        this.receivedAttachments = Collections.singletonList(attachment);
        this.outboundAttachments = Collections.emptyList();
    }

    private void build(List<? extends AbstractUserMessageGenerated<?>> messagesWithAttachment) {
        if (messagesWithAttachment == null || messagesWithAttachment.isEmpty()) {
            this.outboundAttachments = Collections.emptyList();
            this.receivedAttachments = Collections.emptyList();
        } else {
            for (AbstractUserMessageGenerated<?> message : messagesWithAttachment) {
                if (message instanceof InboundMessage) {
                    InboundMessage inboundMessage = (InboundMessage)message;
                    this.receivedAttachments.addAll(DbManager.getInstance().getInboundAttachmentDao().getAttachmentsForMessage(inboundMessage.getItemId()));
                    continue;
                }
                if (message instanceof OwnedMessage) {
                    OwnedMessage ownedMessage = (OwnedMessage)message;
                    this.receivedAttachments.addAll(DbManager.getInstance().getOwnedAttachmentDao().getAttachmentsForMessage(ownedMessage.getItemId()));
                    continue;
                }
                if (message instanceof OutboundMessage) {
                    OutboundMessage outboundMessage = (OutboundMessage)message;
                    this.outboundAttachments.addAll(DbManager.getInstance().getOutboundAttachmentDao().getAttachmentsForMessage(outboundMessage.getItemId()));
                    continue;
                }
                AppLogger.e("Found unexpected kind of message");
            }
        }
    }

    @Override
    public void run() {
        if (this.receivedAttachments.isEmpty() && this.outboundAttachments.isEmpty()) {
            AppLogger.d("AttachmentService: deleteAttachmentsDbTask: no attachments / no messages");
            return;
        }
        for (ReceivedAttachmentGenerated<?> receivedAttachment : this.receivedAttachments) {
            switch (receivedAttachment.getStatus()) {
                case DOWNLOADABLE: 
                case DOWNLOADING: {
                    OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(receivedAttachment.getOwnedIdentityId());
                    if (ownedIdentity == null) {
                        AppLogger.w("DeleteAttachmentDbTask::run this should never happen, ownedIdentity null for attachement : " + String.valueOf(receivedAttachment.getItemId()));
                        break;
                    }
                    Api.getAttachmentApi().markAttachmentForDeletion(ownedIdentity, receivedAttachment);
                    break;
                }
            }
        }
        for (OutboundAttachment attachment : this.outboundAttachments) {
            if (!attachment.isUploading()) continue;
            List<AttachmentRecipientInfo> outboundAttachmentRecipientInfo = DbManager.getInstance().getAttachmentRecipientInfoDao().getDistinctEngineMessageIdentifierForAttachment((Id<OutboundAttachment>)attachment.getItemId());
            OwnedIdentity ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(attachment.getOwnedIdentityId());
            if (ownedIdentity == null) {
                AppLogger.w("DeleteAttachmentDbTask::run this should never happen, ownedIdentity null for attachement : " + String.valueOf(attachment.getItemId()));
                continue;
            }
            for (AttachmentRecipientInfo attachmentRecipientInfo : outboundAttachmentRecipientInfo) {
                EngineWrapper.getInstance().cancelAttachmentUpload(ownedIdentity.getBytesOwnedIdentity(), attachmentRecipientInfo.getEngineMessageIdentifier(), attachment.getIdx());
            }
        }
        try {
            TransactionWrapper.startStatementTransaction(() -> {
                List<InboundAttachment> inboundAttachments = this.receivedAttachments.stream().filter(InboundAttachment.class::isInstance).map(InboundAttachment.class::cast).toList();
                if (!inboundAttachments.isEmpty() && DbManager.getInstance().getInboundAttachmentDao().delete(inboundAttachments) < inboundAttachments.size()) {
                    throw new Exception("Unable to delete all inbound attachments in db");
                }
                List<OwnedAttachment> ownedAttachments = this.receivedAttachments.stream().filter(OwnedAttachment.class::isInstance).map(OwnedAttachment.class::cast).toList();
                if (!ownedAttachments.isEmpty() && DbManager.getInstance().getOwnedAttachmentDao().delete(ownedAttachments) < ownedAttachments.size()) {
                    throw new Exception("Unable to delete all inbound attachments in db");
                }
                if (!this.outboundAttachments.isEmpty() && DbManager.getInstance().getOutboundAttachmentDao().delete(this.outboundAttachments) < this.outboundAttachments.size()) {
                    throw new Exception("Unable to delete all outbound attachments in db");
                }
                Set<Object> fylesSet = !this.receivedAttachments.isEmpty() ? inboundAttachments.stream().map(AbstractAttachmentGenerated::getFyleId).collect(Collectors.toSet()) : (!this.outboundAttachments.isEmpty() ? this.outboundAttachments.stream().map(AbstractAttachmentGenerated::getFyleId).collect(Collectors.toSet()) : Collections.emptySet());
                FileApi._deleteFylesIfOrphansTask(fylesSet);
                AttachmentProgressCache.getInstance().clean(this.receivedAttachments);
                AttachmentProgressCache.getInstance().clean(this.outboundAttachments);
                return null;
            });
        }
        catch (SQLException e) {
            AppLogger.e("AttachmentService: deleteAttachmentsDbTask: Unable to finish transaction, rolling back", e);
            return;
        }
    }
}

