/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.attachment.tasks;

import io.olvid.engine.secure_io.SecureFile;
import io.olvid.engine.secure_io.SecureFileOutputStream;
import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Fyle;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.gen.attachment.OutboundAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.wrappers.TransactionWrapper;
import io.olvid.windows.messenger.engine.attachment.tasks.DeleteDraftAttachmentsDbTask;
import io.olvid.windows.messenger.engine.helpers.files.FileApi;
import io.olvid.windows.messenger.engine.helpers.files.SizeAndSha256;
import io.olvid.windows.messenger.fx.discussions.discussions_tab.DiscussionSelectionModel;
import io.olvid.windows.messenger.fx.misc.OpenGraph;
import io.olvid.windows.messenger.livedata.cache.AttachmentProgressCache;
import io.olvid.windows.messenger.logger.AppLogger;
import java.io.DataInput;
import java.security.MessageDigest;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class CreateDraftAttachmentTask
implements Callable<Optional<OutboundAttachment>> {
    private final Discussion discussion;
    private final DataInput dataInput;
    private final long length;
    private final String name;
    private final String mimeType;
    private float progressValue = 0.0f;
    private final OutboundMessage draftMessage;
    private final int idx;
    private final AtomicBoolean cancelRequested;
    private final AtomicBoolean cancelAllRequested;
    private final Consumer<OutboundAttachment> singleCancelDelegate;
    private Optional<OpenGraph> draftLinkPreviewData;

    public CreateDraftAttachmentTask(Discussion discussion, DataInput dataInput, long length, String name, String mimetype, OutboundMessage associatedDraftMessage, int idx, AtomicBoolean cancelRequested, AtomicBoolean cancelAllRequested, Consumer<OutboundAttachment> cancelDelegate) {
        this.discussion = discussion;
        this.dataInput = dataInput;
        this.name = name;
        this.length = length;
        this.mimeType = mimetype;
        this.draftMessage = associatedDraftMessage;
        this.idx = idx;
        this.cancelRequested = cancelRequested;
        this.cancelAllRequested = cancelAllRequested;
        this.singleCancelDelegate = cancelDelegate;
    }

    @Override
    public Optional<OutboundAttachment> call() {
        AppLogger.d("CreateDraftAttachmentTask begins");
        OwnedIdentity associatedIdentity = DbManager.getInstance().getOwnedIdentityDao().get(this.discussion.getOwnedIdentityId());
        Map<Id<Discussion>, Integer> remaingDraftAttachgments = DiscussionSelectionModel.getInstance().getRemainingDraftAttachmentToCreatePerDiscussion();
        Integer knownRemaining = remaingDraftAttachgments.get(this.discussion.getItemId());
        knownRemaining = knownRemaining == null ? Integer.valueOf(1) : Integer.valueOf(knownRemaining + 1);
        remaingDraftAttachgments.put((Id<Discussion>)this.discussion.getItemId(), knownRemaining);
        Fyle fyle = new Fyle(FileApi._getRandomTemporaryRelativePath(), null);
        OutboundAttachment draftAttachment = new OutboundAttachment(fyle, associatedIdentity, this.discussion, this.draftMessage, this.name, this.mimeType, this.idx);
        try {
            TransactionWrapper.startQueryTransaction(() -> {
                Fyle createdFyle = DbManager.getInstance().getFyleDao().createIfNotExists(fyle);
                if (createdFyle == null) {
                    throw new SQLException("CreateDraftAttachmentTask: Sql error when inserting new fyle");
                }
                draftAttachment.setFyle(createdFyle);
                OutboundAttachment createdAttachment = DbManager.getInstance().getOutboundAttachmentDao().createIfNotExists(draftAttachment);
                if (createdAttachment == null) {
                    throw new SQLException("CreateDraftAttachmentTask: Sql error when inserting new draftAttachment");
                }
                return null;
            });
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        long startTime = System.currentTimeMillis();
        boolean imported = this.importFile(fyle, draftAttachment);
        long endTime = System.currentTimeMillis();
        AppLogger.w("CreateDraftAttachmentTask: importFile took " + (endTime - startTime) + "ms");
        if (imported) {
            AppLogger.d("CreateDraftAttachmentTask finished OK");
            return Optional.of(draftAttachment);
        }
        AppLogger.d("CreateDraftAttachmentTask finished NOT OK");
        return Optional.empty();
    }

    private boolean importFile(Fyle fyle, OutboundAttachment draftAttachment) {
        try {
            if (this.cancelRequested.get() || this.cancelAllRequested.get() || Thread.currentThread().isInterrupted()) {
                new DeleteDraftAttachmentsDbTask(draftAttachment).run();
                return false;
            }
            SizeAndSha256 sizeAndSha256 = this.copyFileWithProgressUpdate(fyle.getFilePath(), draftAttachment);
            if (this.cancelRequested.get() || this.cancelAllRequested.get() || Thread.currentThread().isInterrupted()) {
                new DeleteDraftAttachmentsDbTask(draftAttachment).run();
                return false;
            }
            if (sizeAndSha256 == null) {
                return false;
            }
            OutboundAttachment existingDraftAttachment = DbManager.getInstance().getOutboundAttachmentDao().getDraftByHashAndDiscussion(sizeAndSha256.sha256, this.discussion);
            if (existingDraftAttachment != null) {
                new DeleteDraftAttachmentsDbTask(draftAttachment).run();
                return false;
            }
            draftAttachment.setSize(sizeAndSha256.fileSize);
            Fyle existingFyle = DbManager.getInstance().getFyleDao().getFromHash(sizeAndSha256.sha256);
            if (existingFyle != null) {
                Id<Fyle> fyleToDelete = draftAttachment.getFyleId();
                draftAttachment.setStatus(OutboundAttachmentGenerated.Status.DRAFT_READY);
                draftAttachment.setFyle(existingFyle);
                DbManager.getInstance().getOutboundAttachmentDao().updateAttachmentStatusFyleAndSize(draftAttachment, draftAttachment.getStatus(), draftAttachment.getFyleId(), draftAttachment.getSize());
                AsyncTaskExecutor.submitTask(() -> FileApi._deleteFyleTask(fyleToDelete));
            } else {
                fyle.setSha256(Optional.ofNullable(sizeAndSha256.sha256));
                fyle.moveToFyleDirectory(fyle.getFilePath());
                draftAttachment.setStatus(OutboundAttachmentGenerated.Status.DRAFT_READY);
                DbManager.getInstance().getFyleDao().updateFylePathAndHash(fyle, fyle.getFilePath(), sizeAndSha256.sha256);
                DbManager.getInstance().getOutboundAttachmentDao().updateAttachmentStatusFyleAndSize(draftAttachment, draftAttachment.getStatus(), draftAttachment.getFyleId(), draftAttachment.getSize());
            }
        }
        catch (Exception e) {
            AppLogger.e("CreateDraftAttachmentTask: exception during draftAttachment import: ", e);
            new DeleteDraftAttachmentsDbTask(draftAttachment).run();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SizeAndSha256 copyFileWithProgressUpdate(String destinationRelativeFilePath, OutboundAttachment draftAttachment) {
        byte[] buffer = new byte[32768];
        SecureFile destinationFile = new SecureFile(FileApi.absolutePathFromRelative(destinationRelativeFilePath));
        long fileSize = 0L;
        SizeAndSha256 sizeAndSha256 = null;
        try (SecureFileOutputStream out = new SecureFileOutputStream(destinationFile, SecureFileOutputStream.AccessMode.TRUNCATE, 0L);){
            int readLen;
            MessageDigest h = MessageDigest.getInstance("SHA-256");
            for (long totalLengthRead = 0L; !(totalLengthRead >= this.length || this.cancelRequested.get() || this.cancelAllRequested.get() || Thread.currentThread().isInterrupted()); totalLengthRead += (long)readLen) {
                int len;
                long rem = this.length - totalLengthRead;
                try {
                    len = Math.toIntExact(rem);
                }
                catch (Exception e) {
                    len = Integer.MAX_VALUE;
                }
                int toRead = Math.min(buffer.length, len);
                this.dataInput.readFully(buffer, 0, toRead);
                readLen = toRead;
                h.update(buffer, 0, readLen);
                out.write(buffer, 0, readLen);
                this.progressValue = (float)(fileSize += (long)readLen) / (float)this.length;
                AttachmentProgressCache.getInstance().updateCopying((Id<OutboundAttachment>)draftAttachment.getItemId(), this.progressValue);
            }
            if (this.cancelRequested.get() || Thread.currentThread().isInterrupted()) {
                this.singleCancelDelegate.accept(draftAttachment);
                SizeAndSha256 sizeAndSha2562 = null;
                return sizeAndSha2562;
            }
            sizeAndSha256 = new SizeAndSha256(fileSize, h.digest());
        }
        catch (Exception e) {
            AppLogger.e("ImportAndEncryptFile: error", e);
            new DeleteDraftAttachmentsDbTask(draftAttachment).run();
        }
        finally {
            AttachmentProgressCache.getInstance().doneCopying((Id<OutboundAttachment>)draftAttachment.getItemId());
        }
        return sizeAndSha256;
    }
}

