/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.atom.tasks;

import io.olvid.engine.engine.types.sync.ObvSyncAtom;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.ApplicationSetting;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.DiscussionCustomization;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.Optional;

public final class AtomTasks {
    private AtomTasks() {
    }

    public static void updateContactCustomName(Contact contact, Optional<String> customName, boolean propagate) {
        DbManager.getInstance().getContactDao().updateContactCustomName((Id<Contact>)contact.getItemId(), customName);
        if (propagate) {
            Api.getSyncAtomApi().propagateAppSyncAtomToOtherDevicesIfNeeded(contact.getOwnedIdentityId(), () -> ObvSyncAtom.createContactNicknameChange((byte[])contact.getBytesContactIdentity(), (String)customName.orElse(null)));
        }
    }

    public static void updateGroupCustomName(Group group, Optional<String> customName, boolean propagate) {
        DbManager.getInstance().getGroupDao().updateCustomName((Id<Group>)group.getItemId(), customName);
        if (propagate) {
            Api.getSyncAtomApi().propagateAppSyncAtomToOtherDevicesIfNeeded(group.getOwnedIdentityId(), () -> {
                if (group.isV2()) {
                    return ObvSyncAtom.createGroupV2NicknameChange((byte[])group.getBytesGroupIdentifier(), (String)customName.orElse(null));
                }
                return ObvSyncAtom.createGroupV1NicknameChange((byte[])group.getBytesGroupIdentifier(), (String)customName.orElse(null));
            });
        }
    }

    public static void updateGroupPersonalNote(Group group, Optional<String> note, boolean propagate) {
        DbManager.getInstance().getGroupDao().updatePersonalNote((Id<Group>)group.getItemId(), note);
        if (propagate) {
            Api.getSyncAtomApi().propagateAppSyncAtomToOtherDevicesIfNeeded(group.getOwnedIdentityId(), () -> {
                if (group.isV2()) {
                    return ObvSyncAtom.createGroupV2PersonalNoteChange((byte[])group.getBytesGroupIdentifier(), (String)note.orElse(null));
                }
                return ObvSyncAtom.createGroupV1PersonalNoteChange((byte[])group.getBytesGroupIdentifier(), (String)note.orElse(null));
            });
        }
    }

    public static void updateOwnedIdentityNickname(Id<OwnedIdentity> id, Optional<String> nickname, boolean propagate) {
        DbManager.getInstance().getOwnedIdentityDao().updateNickname(id, nickname);
        if (propagate) {
            Api.getSyncAtomApi().propagateAppSyncAtomToOtherDevicesIfNeeded(id, () -> ObvSyncAtom.createOwnProfileNicknameChange((String)nickname.orElse(null)));
        }
    }

    public static void updateSendReadReceiptContactSetting(Discussion discussion, Boolean value, boolean propagate) {
        DiscussionCustomization discussionCustomization = DbManager.getInstance().getDiscussionCustomizationDao().getDiscussionCustomization((Id<Discussion>)discussion.getItemId());
        DbManager.getInstance().getDiscussionCustomizationDao().updateSendReadReceipt((Id<DiscussionCustomization>)discussionCustomization.getItemId(), value);
        if (propagate) {
            Optional<Id<Contact>> contactOpt = discussion.getContactId();
            if (contactOpt.isEmpty()) {
                AppLogger.e("Try to propagate ContactSendReadReceiptChange for non contact discussion");
                return;
            }
            Contact contact = DbManager.getInstance().getContactDao().get(contactOpt.get());
            boolean val = value != null && value != false;
            Api.getSyncAtomApi().propagateAppSyncAtomToOtherDevicesIfNeeded(discussion.getOwnedIdentityId(), () -> ObvSyncAtom.createContactSendReadReceiptChange((byte[])contact.getBytesContactIdentity(), (Boolean)val));
        }
    }

    public static void updateApplicationSetting(ApplicationSetting.GlobalAppSettings setting, Optional<String> value, boolean propagate) {
        DbManager.getInstance().getApplicationSettingsDao().updateApplicationSetting(setting, value);
        if (propagate) {
            switch (setting) {
                case SEND_READ_RECEIPT_SETTING_KEY: {
                    boolean val = AtomTasks.parseBoolean(value, false);
                    Api.getSyncAtomApi().propagateAppSyncAtomToAllOwnedIdentitiesOtherDevicesIfNeeded(() -> ObvSyncAtom.createSettingDefaultSendReadReceipts((boolean)val));
                    break;
                }
            }
        }
    }

    private static boolean parseBoolean(Optional<String> value, boolean default_) {
        return value.map(Boolean::parseBoolean).orElse(default_);
    }
}

