/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.api;

import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.ObvTransferStep;
import io.olvid.windows.messenger.keycloak.SimpleAuthState;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.Optional;
import java.util.UUID;

public interface TransferApi {
    public void initiateOwnedIdentityTransferProtocolOnTargetDevice(String var1);

    public void initiateOwnedIdentityTransferProtocolOnSourceDevice(OwnedIdentityInfo var1);

    public boolean setTransferSessionNumber(long var1, Step var3, UUID var4, byte[] var5, Encoded var6);

    public boolean setTransferSasAndDeviceUid(String var1, Optional<byte[]> var2, Step var3, UUID var4, byte[] var5, Encoded var6);

    public boolean setTransferAuthenticationProof(byte[] var1, Step var2, UUID var3, Encoded var4, String var5, SimpleAuthState var6);

    public boolean abortTransfer(Step var1, UUID var2, byte[] var3, Encoded var4);

    public static Optional<Step> of(ObvTransferStep step) {
        return switch (step.getStep()) {
            default -> throw new MatchException(null, null);
            case ObvTransferStep.Step.FAIL -> {
                ObvTransferStep.Fail fail = (ObvTransferStep.Fail)step;
                Error error = switch (fail.failReason) {
                    case 1 -> Error.NETWORK_ERROR;
                    case 2 -> Error.TRANSFERRED_IDENTITY_ALREADY_EXISTS;
                    case 3 -> Error.INVALID_RESPONSE;
                    default -> {
                        AppLogger.e("Found unexpected fail reason " + fail.failReason);
                        yield Error.INVALID_RESPONSE;
                    }
                };
                yield Optional.of(new Fail(error));
            }
            case ObvTransferStep.Step.SOURCE_WAIT_FOR_SESSION_NUMBER -> Optional.of(new SourceWaitForSessionNumber());
            case ObvTransferStep.Step.SOURCE_DISPLAY_SESSION_NUMBER -> {
                ObvTransferStep.SourceDisplaySessionNumber sourceDisplaySessionNumber = (ObvTransferStep.SourceDisplaySessionNumber)step;
                yield Optional.of(new SourceDisplaySessionNumber(String.format("%08d", sourceDisplaySessionNumber.sessionNumber)));
            }
            case ObvTransferStep.Step.TARGET_SESSION_NUMBER_INPUT -> Optional.of(new TargetSessionNumberInput());
            case ObvTransferStep.Step.ONGOING_PROTOCOL -> Optional.of(new OngoingProtocol());
            case ObvTransferStep.Step.SOURCE_SAS_INPUT -> {
                ObvTransferStep.SourceSasInput sourceSasInput = (ObvTransferStep.SourceSasInput)step;
                yield Optional.of(new SourceSasInput(sourceSasInput.correctSas, sourceSasInput.targetDeviceName));
            }
            case ObvTransferStep.Step.TARGET_SHOW_SAS -> {
                ObvTransferStep.TargetShowSas targetShowSas = (ObvTransferStep.TargetShowSas)step;
                yield Optional.of(new TargetShowSas(targetShowSas.sas));
            }
            case ObvTransferStep.Step.SOURCE_SNAPSHOT_SENT -> Optional.of(new SourceSnapshotSent());
            case ObvTransferStep.Step.TARGET_SNAPSHOT_RECEIVED -> Optional.of(new TargetSnapshotReceived());
            case ObvTransferStep.Step.TARGET_REQUESTS_KEYCLOAK_AUTHENTICATION_PROOF -> {
                AppLogger.d("TransferApi::TARGET_REQUESTS_KEYCLOAK_AUTHENTICATION_PROOF not implemented yet ");
                ObvTransferStep.TargetRequestsKeycloakAuthenticationProof targetRequestsKeycloakAuthenticationProof = (ObvTransferStep.TargetRequestsKeycloakAuthenticationProof)step;
                yield Optional.of(new TargetRequestKeycloakAuthenticationProof(targetRequestsKeycloakAuthenticationProof.keycloakServerUrl, targetRequestsKeycloakAuthenticationProof.clientId, targetRequestsKeycloakAuthenticationProof.clientSecret, targetRequestsKeycloakAuthenticationProof.fullSas, targetRequestsKeycloakAuthenticationProof.sessionNumber));
            }
        };
    }

    public static enum Error {
        NETWORK_ERROR(1),
        TRANSFERRED_IDENTITY_ALREADY_EXISTS(2),
        INVALID_RESPONSE(3);

        public final int id;

        private Error(int id) {
            this.id = id;
        }
    }

    public record Fail(Error e) implements Step
    {
        @Override
        public Kind getKind() {
            return Kind.FAIL;
        }

        @Override
        public ObvTransferStep toObvTransferStep() {
            return new ObvTransferStep.Fail(this.e.id);
        }
    }

    public record SourceWaitForSessionNumber() implements Step
    {
        @Override
        public Kind getKind() {
            return Kind.SOURCE_WAIT_FOR_SESSION_NUMBER;
        }

        @Override
        public ObvTransferStep toObvTransferStep() {
            return new ObvTransferStep.SourceWaitForSessionNumberStep();
        }
    }

    public record SourceDisplaySessionNumber(String value) implements Step
    {
        @Override
        public Kind getKind() {
            return Kind.SOURCE_DISPLAY_SESSION_NUMBER;
        }

        @Override
        public ObvTransferStep toObvTransferStep() {
            return new ObvTransferStep.SourceDisplaySessionNumber(Long.valueOf(this.value).longValue());
        }
    }

    public record TargetSessionNumberInput() implements Step
    {
        @Override
        public Kind getKind() {
            return Kind.TARGET_SESSION_NUMBER_INPUT;
        }

        @Override
        public ObvTransferStep toObvTransferStep() {
            return new ObvTransferStep.TargetSessionNumberInput();
        }
    }

    public record OngoingProtocol() implements Step
    {
        @Override
        public Kind getKind() {
            return Kind.ONGOING_PROTOCOL;
        }

        @Override
        public ObvTransferStep toObvTransferStep() {
            return new ObvTransferStep.OngoingProtocol();
        }
    }

    public record SourceSasInput(String correctSas, String targetDeviceName) implements Step
    {
        @Override
        public Kind getKind() {
            return Kind.SOURCE_SAS_INPUT;
        }

        @Override
        public ObvTransferStep toObvTransferStep() {
            return new ObvTransferStep.SourceSasInput(this.correctSas, this.targetDeviceName);
        }
    }

    public record TargetShowSas(String sas) implements Step
    {
        @Override
        public Kind getKind() {
            return Kind.TARGET_SHOW_SAS;
        }

        @Override
        public ObvTransferStep toObvTransferStep() {
            return new ObvTransferStep.TargetShowSas(this.sas);
        }
    }

    public record SourceSnapshotSent() implements Step
    {
        @Override
        public Kind getKind() {
            return Kind.SOURCE_SNAPSHOT_SENT;
        }

        @Override
        public ObvTransferStep toObvTransferStep() {
            return new ObvTransferStep.SourceSnapshotSent();
        }
    }

    public record TargetSnapshotReceived() implements Step
    {
        @Override
        public Kind getKind() {
            return Kind.TARGET_SNAPSHOT_RECEIVED;
        }

        @Override
        public ObvTransferStep toObvTransferStep() {
            return new ObvTransferStep.TargetSnapshotReceived();
        }
    }

    public record TargetRequestKeycloakAuthenticationProof(String keycloakServerUrl, String clientId, String clientSecret, String fullSas, long sessionNumber) implements Step
    {
        @Override
        public Kind getKind() {
            return Kind.TARGET_REQUESTS_KEYCLOAK_AUTHENTICATION_PROOF;
        }

        @Override
        public ObvTransferStep toObvTransferStep() {
            return new ObvTransferStep.TargetRequestsKeycloakAuthenticationProof(this.keycloakServerUrl, this.clientId, this.clientSecret, this.fullSas, this.sessionNumber);
        }
    }

    public static interface Step {
        public Kind getKind();

        public ObvTransferStep toObvTransferStep();
    }

    public static enum Kind {
        FAIL,
        SOURCE_WAIT_FOR_SESSION_NUMBER,
        SOURCE_DISPLAY_SESSION_NUMBER,
        TARGET_SESSION_NUMBER_INPUT,
        ONGOING_PROTOCOL,
        SOURCE_SAS_INPUT,
        TARGET_SHOW_SAS,
        SOURCE_SNAPSHOT_SENT,
        TARGET_SNAPSHOT_RECEIVED,
        TARGET_REQUESTS_KEYCLOAK_AUTHENTICATION_PROOF;

    }
}

