/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.api;

import io.olvid.engine.engine.types.identities.ObvIdentity;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.api.OwnedIdentityApi;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.Objects;

class OwnedIdentityApiImpl
implements OwnedIdentityApi {
    OwnedIdentityApiImpl() {
    }

    @Override
    public void downloadMessages(byte[] ownedIdentityBytes) {
        Objects.requireNonNull(ownedIdentityBytes);
        EngineWrapper.getInstance().downloadMessages(ownedIdentityBytes);
    }

    @Override
    public ObvIdentity[] getOwnedIdentities() {
        try {
            return EngineWrapper.getInstance().getOwnedIdentities();
        }
        catch (Exception e) {
            AppLogger.e("OwnedIdentityApiImpl::hasOwnedIdentities couldn't retrieve owned identities from engine", e);
            return new ObvIdentity[0];
        }
    }

    @Override
    public boolean hasOwnedIdentities() {
        try {
            return EngineWrapper.getInstance().getOwnedIdentities().length > 0;
        }
        catch (Exception e) {
            AppLogger.e("OwnedIdentityApiImpl::hasOwnedIdentities couldn't retrieve owned identities from engine", e);
            return false;
        }
    }
}

