/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.olvid.engine.datatypes.containers.GroupV2;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.engine.types.JsonGroupDetails;
import io.olvid.engine.engine.types.ObvBytesKey;
import io.olvid.engine.engine.types.identities.ObvGroupV2;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.api.GroupApi;
import io.olvid.windows.messenger.engine.api.GroupCreationInterface;
import io.olvid.windows.messenger.engine.api.GroupUpdateInput;
import io.olvid.windows.messenger.engine.helpers.groups.GroupHelper;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.BytesKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

class GroupV2ApiImpl
implements GroupApi,
GroupCreationInterface {
    GroupV2ApiImpl() {
    }

    @Override
    public boolean createGroup(byte[] bytesOwnedIdentity, Optional<String> name, Optional<String> description, Optional<String> absolutePhotoUrl, Set<String> ownPermissionsAsStrings, Map<BytesKey, Set<String>> otherGroupMembers, String serializedGroupTypeOpt) {
        try {
            if (serializedGroupTypeOpt.isEmpty()) {
                AppLogger.w("GroupV2ApiImpl::createGroupV2 Missing group type for GroupV2 creation");
                return false;
            }
            JsonGroupDetails jsonGroupDetails = new JsonGroupDetails((String)name.orElse(null), (String)description.orElse(null));
            String serializedGroupDetails = EngineWrapper.getJsonObjectMapper().writeValueAsString((Object)jsonGroupDetails);
            HashSet ownPermissions = GroupV2.Permission.fromStrings(ownPermissionsAsStrings);
            HashMap<ObvBytesKey, HashSet<GroupV2.Permission>> otherPermissions = new HashMap<ObvBytesKey, HashSet<GroupV2.Permission>>(otherGroupMembers.size());
            for (BytesKey permissionPerMemberBytes : otherGroupMembers.keySet()) {
                otherPermissions.put(new ObvBytesKey(permissionPerMemberBytes.bytes), GroupV2.Permission.fromStrings((Collection)otherGroupMembers.get(permissionPerMemberBytes)));
            }
            EngineWrapper.getInstance().startGroupV2CreationProtocol(serializedGroupDetails, absolutePhotoUrl.orElse(null), bytesOwnedIdentity, ownPermissions, otherPermissions, serializedGroupTypeOpt);
            AppLogger.i("GroupV2ApiImpl::createGroupV2 Started group creation protocol successfully with group " + String.valueOf(name));
            return true;
        }
        catch (JsonProcessingException jsonProcessingException) {
            AppLogger.e("GroupV2ApiImpl::createGroupV2 couldn't process group json details... ", (Exception)((Object)jsonProcessingException));
        }
        catch (Exception e) {
            AppLogger.e("GroupV2ApiImpl::createGroupV2 Exception occurred during engine call...", e);
        }
        return false;
    }

    @Override
    public boolean updateGroup(GroupUpdateInput groupUpdateInput) {
        ObvGroupV2.ObvGroupV2ChangeSet changeSet = new ObvGroupV2.ObvGroupV2ChangeSet();
        try {
            changeSet.updatedSerializedGroupDetails = GroupHelper.computeV2GroupDetailsChanges(groupUpdateInput.ownedIdentityBytes(), groupUpdateInput.groupIdentifier(), groupUpdateInput.name(), groupUpdateInput.description()).orElse(null);
            changeSet.updatedPhotoUrl = groupUpdateInput.absolutePhotoUrl().orElse(null);
            this.updateMembersAndPermissionsInChangeSet(changeSet, groupUpdateInput.identitiesToRemove(), groupUpdateInput.permissionChanges(), groupUpdateInput.permissionsPerNewMembers());
            EngineWrapper.getInstance().initiateGroupV2Update(groupUpdateInput.ownedIdentityBytes(), groupUpdateInput.groupIdentifier(), changeSet);
            return true;
        }
        catch (JsonProcessingException jsonProcessingException) {
            AppLogger.e("GroupV2ApiImpl::updateGroup couldn't process group json details... ", (Exception)((Object)jsonProcessingException));
        }
        catch (Exception e) {
            AppLogger.e("GroupV2ApiImpl::updateGroup Exception occurred during engine call...", e);
        }
        return false;
    }

    @Override
    public boolean updateGroupMembers(byte[] bytesOwnedIdentity, byte[] groupIdentifier, Set<BytesKey> identitiesToRemove, Map<BytesKey, Set<String>> permissionChanges, Map<BytesKey, Set<String>> permissionsPerNewMembers) {
        if (bytesOwnedIdentity == null || groupIdentifier == null) {
            AppLogger.e("GroupV2ApiImpl::updateGroupMembers bad parameters");
        }
        ObvGroupV2.ObvGroupV2ChangeSet changeSet = new ObvGroupV2.ObvGroupV2ChangeSet();
        this.updateMembersAndPermissionsInChangeSet(changeSet, identitiesToRemove, permissionChanges, permissionsPerNewMembers);
        try {
            EngineWrapper.getInstance().initiateGroupV2Update(bytesOwnedIdentity, groupIdentifier, changeSet);
            return true;
        }
        catch (Exception e) {
            AppLogger.e("GroupV2ApiImpl::updateGroupMembers Exception occurred during engine call...", e);
            return false;
        }
    }

    @Override
    public boolean updateGroupDetails(byte[] bytesOwnedIdentity, byte[] groupIdentifier, Optional<String> groupName, Optional<String> description, Optional<String> photoUrl) {
        if (bytesOwnedIdentity == null || groupIdentifier == null) {
            AppLogger.e("GroupV2ApiImpl::updateGroupDetails bad parameters");
        }
        ObvGroupV2.ObvGroupV2ChangeSet changeSet = new ObvGroupV2.ObvGroupV2ChangeSet();
        changeSet.updatedSerializedGroupDetails = GroupHelper.computeV2GroupDetailsChanges(bytesOwnedIdentity, groupIdentifier, groupName, description).orElse(null);
        changeSet.updatedPhotoUrl = photoUrl.orElse(null);
        if (changeSet.updatedSerializedGroupDetails != null && changeSet.updatedPhotoUrl != null) {
            try {
                EngineWrapper.getInstance().initiateGroupV2Update(bytesOwnedIdentity, groupIdentifier, changeSet);
                return true;
            }
            catch (Exception e) {
                AppLogger.e("GroupV2ApiImpl::trustDetails Exception occurred during engine call...", e);
            }
        }
        return false;
    }

    @Override
    public boolean updateGroupPhoto(byte[] bytesOwnedIdentity, byte[] groupIdentifier, Optional<String> photoUrl) {
        if (bytesOwnedIdentity == null || groupIdentifier == null) {
            AppLogger.e("GroupV2ApiImpl::updateGroupPhoto bad parameters");
        }
        try {
            ObvGroupV2.ObvGroupV2ChangeSet changeSet = new ObvGroupV2.ObvGroupV2ChangeSet();
            changeSet.updatedPhotoUrl = photoUrl.orElse(null);
            EngineWrapper.getInstance().initiateGroupV2Update(bytesOwnedIdentity, groupIdentifier, changeSet);
            return true;
        }
        catch (JsonProcessingException jsonProcessingException) {
            AppLogger.e("GroupV2ApiImpl::updateGroupPhoto couldn't process group json details... ", (Exception)((Object)jsonProcessingException));
        }
        catch (Exception e) {
            AppLogger.e("GroupV2ApiImpl::updateGroupPhoto Exception occurred during engine call...", e);
        }
        return false;
    }

    @Override
    public boolean trustDetails(byte[] bytesOwnedIdentity, byte[] bytesGroupIdentifier) {
        if (bytesOwnedIdentity == null || bytesGroupIdentifier == null) {
            AppLogger.e("GroupV2ApiImpl::trustDetails bad parameters");
        }
        try {
            EngineWrapper.getInstance().trustGroupV2PublishedDetails(bytesOwnedIdentity, bytesGroupIdentifier);
            return true;
        }
        catch (Exception e) {
            AppLogger.e("GroupV2ApiImpl::trustDetails Exception occurred during engine call...", e);
            return false;
        }
    }

    @Override
    public boolean disbandGroup(byte[] bytesOwnedIdentity, byte[] groupIdentifier) {
        if (bytesOwnedIdentity == null || groupIdentifier == null) {
            AppLogger.e("GroupV2ApiImpl::disbandGroup bad parameters");
        }
        try {
            EngineWrapper.getInstance().disbandGroupV2(bytesOwnedIdentity, groupIdentifier);
            return true;
        }
        catch (Exception e) {
            AppLogger.e("GroupV2ApiImpl::disbandGroup Exception occurred during engine call...", e);
            return false;
        }
    }

    @Override
    public boolean leaveGroup(byte[] bytesOwnedIdentity, byte[] groupIdentifier) {
        if (bytesOwnedIdentity == null || groupIdentifier == null) {
            AppLogger.e("GroupV2ApiImpl::leaveGroup bad parameters");
        }
        try {
            EngineWrapper.getInstance().leaveGroupV2(bytesOwnedIdentity, groupIdentifier);
            return true;
        }
        catch (Exception e) {
            AppLogger.e("GroupV2ApiImpl::leaveGroup Exception occurred during engine call...", e);
            return false;
        }
    }

    @Override
    public boolean refreshGroup(byte[] bytesOwnedIdentity, byte[] groupIdentifier) {
        try {
            EngineWrapper.getInstance().reDownloadGroupV2(bytesOwnedIdentity, groupIdentifier);
            return true;
        }
        catch (Exception e) {
            AppLogger.e("GroupV2ApiImpl::refreshGroup Exception occurred during engine call...", e);
            return false;
        }
    }

    public boolean isGroupUpdateInProgress(byte[] bytesOwnedIdentity, byte[] groupIdentifier) {
        try {
            return EngineWrapper.getInstance().isGroupV2UpdateInProgress(bytesOwnedIdentity, GroupV2.Identifier.of((byte[])groupIdentifier));
        }
        catch (DecodingException e) {
            AppLogger.e("GroupV2ApiImpl::isGroupUpdateInProgress Exception occurred decoding groupV2 identifier...", (Exception)((Object)e));
        }
        catch (Exception e) {
            AppLogger.e("GroupV2ApiImpl::isGroupUpdateInProgress Exception occurred during engine call...", e);
        }
        return false;
    }

    private void updateMembersAndPermissionsInChangeSet(ObvGroupV2.ObvGroupV2ChangeSet changeSet, Set<BytesKey> identitiesToRemove, Map<BytesKey, Set<String>> permissionChanges, Map<BytesKey, Set<String>> permissionsPerNewMembers) {
        if (permissionsPerNewMembers != null) {
            for (BytesKey permissionPerMemberBytes : permissionsPerNewMembers.keySet()) {
                changeSet.addedMembersWithPermissions.put(new ObvBytesKey(permissionPerMemberBytes.bytes), GroupV2.Permission.fromStrings((Collection)permissionsPerNewMembers.get(permissionPerMemberBytes)));
            }
        }
        if (permissionChanges != null) {
            for (BytesKey permissionPerMemberBytes : permissionChanges.keySet()) {
                changeSet.permissionChanges.put(new ObvBytesKey(permissionPerMemberBytes.bytes), GroupV2.Permission.fromStrings((Collection)permissionChanges.get(permissionPerMemberBytes)));
            }
        }
        if (identitiesToRemove != null) {
            for (BytesKey identityBytes : identitiesToRemove) {
                changeSet.removedMembers.add(identityBytes.bytes);
            }
        }
    }
}

