/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.api;

import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.BytesKey;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public record GroupUpdateInput(byte[] ownedIdentityBytes, byte[] groupIdentifier, Optional<String> name, Optional<String> description, Optional<String> personalNote, Optional<String> absolutePhotoUrl, Set<BytesKey> identitiesToRemove, Map<BytesKey, Set<String>> permissionChanges, Map<BytesKey, Set<String>> permissionsPerNewMembers) {
    public static Builder builder(byte[] ownedIdentityBytes, byte[] groupIdentifier) {
        return new Builder(ownedIdentityBytes, groupIdentifier);
    }

    public static class Builder {
        private byte[] ownedIdentityBytes;
        private byte[] groupIdentifier;
        private String name;
        private String description;
        private String personalNote;
        private String absolutePhotoUrl;
        private Set<BytesKey> identitiesToRemove;
        private Map<BytesKey, Set<String>> permissionChanges;
        private Map<BytesKey, Set<String>> permissionsPerNewMembers;

        public Builder(byte[] ownedIdentityBytes, byte[] groupIdentifier) {
            if (ownedIdentityBytes == null || groupIdentifier == null) {
                AppLogger.e("GroupUpdateInput: Builder(): invalid parameter");
                return;
            }
            this.ownedIdentityBytes = ownedIdentityBytes;
            this.groupIdentifier = groupIdentifier;
        }

        public Builder setName(String name) {
            if (this.name == null) {
                this.name = name;
            } else {
                AppLogger.e("GroupUpdateInput:Builder name already set");
            }
            return this;
        }

        public Builder setDescription(String description) {
            if (this.description == null) {
                this.description = description;
            } else {
                AppLogger.e("GroupUpdateInput:Builder description already set");
            }
            return this;
        }

        public Builder setPersonalNote(String personalNote) {
            if (this.personalNote == null) {
                this.personalNote = personalNote;
            } else {
                AppLogger.e("GroupUpdateInput:Builder personal note already set");
            }
            return this;
        }

        public Builder setAbsolutePhotoUrl(String absolutePhotoUrl) {
            if (this.absolutePhotoUrl == null) {
                this.absolutePhotoUrl = absolutePhotoUrl;
            } else {
                AppLogger.e("GroupUpdateInput:Builder Absolute PhotoUrl already set");
            }
            return this;
        }

        public Builder setIdentitiesToRemove(Set<BytesKey> identitiesToRemove) {
            if (this.identitiesToRemove == null) {
                this.identitiesToRemove = identitiesToRemove;
            } else {
                AppLogger.e("GroupUpdateInput:Builder identities already set");
            }
            return this;
        }

        public Builder setPermissionChanges(Map<BytesKey, Set<String>> permissionChanges) {
            if (this.permissionChanges == null) {
                this.permissionChanges = permissionChanges;
            } else {
                AppLogger.e("GroupUpdateInput:Builder permission changes already set");
            }
            return this;
        }

        public Builder setPermissionPerNewMembers(Map<BytesKey, Set<String>> permissionsPerNewMembers) {
            if (this.permissionsPerNewMembers == null) {
                this.permissionsPerNewMembers = permissionsPerNewMembers;
            } else {
                AppLogger.e("GroupUpdateInput:Builder permission new members already set");
            }
            return this;
        }

        public GroupUpdateInput build() {
            return new GroupUpdateInput(this.ownedIdentityBytes, this.groupIdentifier, Optional.ofNullable(this.name), Optional.ofNullable(this.description), Optional.ofNullable(this.personalNote), Optional.ofNullable(this.absolutePhotoUrl), this.identitiesToRemove == null ? Collections.emptySet() : this.identitiesToRemove, this.permissionChanges == null ? Collections.emptyMap() : this.permissionChanges, this.permissionsPerNewMembers == null ? Collections.emptyMap() : this.permissionsPerNewMembers);
        }
    }
}

