/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.engine.api;

import io.olvid.windows.messenger.database.tables.gen.GroupGenerated;
import io.olvid.windows.messenger.engine.api.AttachmentApi;
import io.olvid.windows.messenger.engine.api.AttachmentApiImpl;
import io.olvid.windows.messenger.engine.api.BackupApi;
import io.olvid.windows.messenger.engine.api.BackupApiImpl;
import io.olvid.windows.messenger.engine.api.DeviceApi;
import io.olvid.windows.messenger.engine.api.DeviceApiImpl;
import io.olvid.windows.messenger.engine.api.GroupApi;
import io.olvid.windows.messenger.engine.api.GroupCreationInterface;
import io.olvid.windows.messenger.engine.api.GroupV1ApiImpl;
import io.olvid.windows.messenger.engine.api.GroupV2ApiImpl;
import io.olvid.windows.messenger.engine.api.LifecycleApi;
import io.olvid.windows.messenger.engine.api.LifecycleApiImpl;
import io.olvid.windows.messenger.engine.api.MessageApi;
import io.olvid.windows.messenger.engine.api.MessageApiImpl;
import io.olvid.windows.messenger.engine.api.OwnedIdentityApi;
import io.olvid.windows.messenger.engine.api.OwnedIdentityApiImpl;
import io.olvid.windows.messenger.engine.api.SyncAtomApi;
import io.olvid.windows.messenger.engine.api.SyncAtomApiImpl;
import io.olvid.windows.messenger.engine.api.TransferApi;
import io.olvid.windows.messenger.engine.api.TransferApiImpl;
import io.olvid.windows.messenger.logger.AppLogger;

public final class Api {
    private static final Api instance = new Api();
    private final MessageApi messageApi = new MessageApiImpl();
    private final AttachmentApi attachmentApi = new AttachmentApiImpl();
    private final SyncAtomApi syncAtomApi = new SyncAtomApiImpl();
    private final TransferApi transferApi = new TransferApiImpl();
    private final DeviceApi deviceApi = new DeviceApiImpl();
    private final GroupApi groupApiV1 = new GroupV1ApiImpl();
    private final GroupApi groupApiV2 = new GroupV2ApiImpl();
    private final OwnedIdentityApi ownedIdentityApi = new OwnedIdentityApiImpl();
    private final LifecycleApi lifecycleApi = new LifecycleApiImpl();
    private final BackupApi backupApi = new BackupApiImpl();

    private Api() {
    }

    public static LifecycleApi getLifecycleApi() {
        return Api.instance.lifecycleApi;
    }

    public static MessageApi getMessageApi() {
        return Api.instance.messageApi;
    }

    public static AttachmentApi getAttachmentApi() {
        return Api.instance.attachmentApi;
    }

    public static SyncAtomApi getSyncAtomApi() {
        return Api.instance.syncAtomApi;
    }

    public static TransferApi getTransferApi() {
        return Api.instance.transferApi;
    }

    public static DeviceApi getDeviceApi() {
        return Api.instance.deviceApi;
    }

    public static GroupApi getGroupApi(GroupGenerated.Version version) {
        switch (version) {
            case VERSION_1: {
                return Api.instance.groupApiV1;
            }
            case VERSION_2: {
                return Api.instance.groupApiV2;
            }
        }
        AppLogger.w("Api::getGroupApi() returning groupV2Api implementation");
        return Api.instance.groupApiV2;
    }

    public static GroupCreationInterface getGroupCreationApi(GroupGenerated.Version version) {
        switch (version) {
            case VERSION_1: {
                return (GroupCreationInterface)((Object)Api.instance.groupApiV1);
            }
            case VERSION_2: {
                return (GroupCreationInterface)((Object)Api.instance.groupApiV2);
            }
        }
        AppLogger.w("Api::getGroupCreationApi() returning groupV2Api implementation");
        return (GroupCreationInterface)((Object)Api.instance.groupApiV2);
    }

    public static OwnedIdentityApi getOwnedIdentityApi() {
        return Api.instance.ownedIdentityApi;
    }

    public static BackupApi getBackupApi() {
        return Api.instance.backupApi;
    }
}

