/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables.message;

import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.datatypes.json.JsonExpiration;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.gen.message.SystemMessageGenerated;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import io.olvid.windows.messenger.livedata.info.IdentityInfo;
import io.olvid.windows.messenger.misc.DateUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Optional;

@DatabaseTable(tableName="system_message_table")
public class SystemMessage
extends SystemMessageGenerated<SystemMessage>
implements SystemMessageGenerated.Interface {
    public SystemMessage() {
    }

    public SystemMessage(long genId, Discussion discussion, long senderSequenceNumber, double sortIndex, long timestamp, SystemMessageGenerated.Category category, IdentityRef identityRef, Boolean readOnce, Long visibilityDuration, Long existenceDuration) {
        super(genId, discussion, senderSequenceNumber, sortIndex, timestamp, category, identityRef, readOnce, visibilityDuration, existenceDuration);
    }

    @Override
    protected Class<SystemMessage> getClazz() {
        return SystemMessage.class;
    }

    public static Optional<JsonExpiration> getExpiration(SystemMessageGenerated.Interface message) {
        if (message.getReadOnce().isEmpty() && message.getVisibilityDuration().isEmpty() && message.getExistenceDuration().isEmpty()) {
            return Optional.empty();
        }
        JsonExpiration jsonExpiration = new JsonExpiration();
        jsonExpiration.setReadOnce(message.getReadOnce().orElse(null));
        jsonExpiration.setVisibilityDuration(message.getVisibilityDuration().orElse(null));
        jsonExpiration.setExistenceDuration(message.getExistenceDuration().orElse(null));
        return Optional.of(jsonExpiration);
    }

    public String getStringContent() {
        return SystemMessage.getStringContent(this, Optional.empty(), 0L);
    }

    public static String getStringContent(SystemMessageGenerated.Interface message, Optional<IdentityInfo> identityInfo, long timestamp) {
        Optional identityName = identityInfo.flatMap(info -> info.getCustomDisplayNameOrDisplayName(IdentityDetailsInfo.Format.FIRST_LAST));
        return switch (message.getCategory()) {
            default -> throw new MatchException(null, null);
            case SystemMessageGenerated.Category.GROUP_MEMBER_JOINED -> {
                if (identityName.isPresent()) {
                    yield ViewControllerHelper.getString("message_content_contact_joined_the_group", identityName.get());
                }
                yield ViewControllerHelper.getString("message_content_unknown_contact_joined_the_group");
            }
            case SystemMessageGenerated.Category.GROUP_MEMBER_LEFT -> {
                if (identityName.isPresent()) {
                    yield ViewControllerHelper.getString("message_content_contact_left_the_group", identityName.get());
                }
                yield ViewControllerHelper.getString("message_content_unknown_contact_left_the_group");
            }
            case SystemMessageGenerated.Category.LEFT_GROUP -> ViewControllerHelper.getString("message_content_left_group");
            case SystemMessageGenerated.Category.JOINED_GROUP -> ViewControllerHelper.getString("message_content_joined_group");
            case SystemMessageGenerated.Category.RE_JOINED_GROUP -> ViewControllerHelper.getString("message_content_rejoined_group");
            case SystemMessageGenerated.Category.CONTACT_DELETED -> ViewControllerHelper.getString("message_content_contact_deleted");
            case SystemMessageGenerated.Category.DISCUSSION_SETTINGS_UPDATE -> {
                Optional<JsonExpiration> jsonExpirationOpt = SystemMessage.getExpiration(message);
                StringBuilder builder = new StringBuilder();
                if (identityInfo.isPresent() && identityName.isPresent()) {
                    if (identityInfo.get().isMe()) {
                        builder.append(ViewControllerHelper.getString("message_content_discussion_setting_updated_by_you"));
                    } else {
                        MessageFormat messageFormat = new MessageFormat(ViewControllerHelper.getString("message_content_discussion_setting_updated_by_contact"));
                        builder.append(messageFormat.format(new String[]{(String)identityName.get()}));
                    }
                } else {
                    builder.append(ViewControllerHelper.getString("message_content_discussion_setting_updated"));
                }
                if (jsonExpirationOpt.isPresent()) {
                    JsonExpiration jsonExpiration = jsonExpirationOpt.get();
                    ArrayList<String> settings = new ArrayList<String>();
                    if (jsonExpiration.getReadOnce() != null && jsonExpiration.getReadOnce().booleanValue()) {
                        settings.add("\ud83d\udd25");
                    }
                    if (jsonExpiration.getVisibilityDuration() != null) {
                        settings.add(String.format("%s %s", "\ud83d\udc40", DateUtils.formatDurationPlainText(jsonExpiration.getVisibilityDuration())));
                    }
                    if (jsonExpiration.getExistenceDuration() != null) {
                        settings.add(String.format("%s %s", "\u23f1\ufe0f", DateUtils.formatDurationPlainText(jsonExpiration.getExistenceDuration())));
                    }
                    if (!settings.isEmpty()) {
                        builder.append(System.lineSeparator());
                        builder.append(String.join((CharSequence)"  ", settings));
                    }
                } else {
                    builder.append(System.lineSeparator());
                    builder.append(ViewControllerHelper.getString("non_ephemeral_messages"));
                }
                yield builder.toString();
            }
            case SystemMessageGenerated.Category.DISCUSSION_REMOTELY_DELETED -> {
                if (identityName.isPresent()) {
                    yield ViewControllerHelper.getString("message_content_discussion_remotely_deleted_by", identityName.get());
                }
                yield ViewControllerHelper.getString("message_content_discussion_remotely_deleted");
            }
            case SystemMessageGenerated.Category.NEW_PUBLISHED_DETAILS -> ViewControllerHelper.getString("message_content_new_published_details");
            case SystemMessageGenerated.Category.CONTACT_REVOKED -> ViewControllerHelper.getString("message_content_contact_was_blocked_revoked");
            case SystemMessageGenerated.Category.CONTACT_FORCEFULLY_UNBLOCKED -> ViewControllerHelper.getString("message_content_contact_was_blocked");
            case SystemMessageGenerated.Category.CONTACT_RE_ADDED -> ViewControllerHelper.getString("message_content_contact_re_added");
            case SystemMessageGenerated.Category.GAINED_GROUP_ADMIN -> ViewControllerHelper.getString("message_content_you_became_admin");
            case SystemMessageGenerated.Category.LOST_GROUP_ADMIN -> ViewControllerHelper.getString("message_content_you_are_no_longer_admin");
            case SystemMessageGenerated.Category.GROUP_MEMBERS_JOINED -> ViewControllerHelper.getString("message_content_members_joined_the_group");
            case SystemMessageGenerated.Category.GROUP_MEMBERS_LEFT -> ViewControllerHelper.getString("message_content_members_left_the_group");
        };
    }
}

