/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables.message;

import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Location;
import io.olvid.windows.messenger.database.tables.ephemerality.OutboundMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.OutboundMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.MessageRef;
import io.olvid.windows.messenger.engine.helpers.message.MessageHelper;
import java.util.Optional;
import java.util.UUID;

@DatabaseTable(tableName="outbound_message_table")
public final class OutboundMessage
extends OutboundMessageGenerated<OutboundMessage>
implements OutboundMessageGenerated.Interface {
    public OutboundMessage() {
    }

    public OutboundMessage(long genId) {
        super(genId);
    }

    public OutboundMessage(long genId, Discussion discussion, long senderSequenceNumber, double sortIndex, long timestamp, String body, MessageRef replyTo, Location location, AbstractUserMessageGenerated.WipeStatus wipeStatus, UUID senderThreadIdentifier, int totalAttachmentCount, int imageCount, AbstractUserMessageGenerated.LinkPreviewKind linkPreviewKind, String linkPreviewDescription, Double linkPreviewImageWidth, AbstractUserMessageGenerated.EditionStatus editionStatus, boolean forwarded, OutboundMessageEphemeralInfo outboundMessageEphemeralInfo, OutboundMessageGenerated.Status status) {
        super(genId, discussion, senderSequenceNumber, sortIndex, timestamp, body, replyTo, location, wipeStatus, senderThreadIdentifier, totalAttachmentCount, imageCount, linkPreviewKind, linkPreviewDescription, linkPreviewImageWidth, editionStatus, forwarded, outboundMessageEphemeralInfo, status);
    }

    @Override
    protected Class<OutboundMessage> getClazz() {
        return OutboundMessage.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double computeSortIndex(Discussion discussion) {
        Object object = MessageHelper.sortIndexLock;
        synchronized (object) {
            Optional<Double> maxSortIndex = MessageHelper.getDiscussionMaxSortIndex(discussion);
            if (maxSortIndex.isPresent()) {
                return maxSortIndex.get() + 10.0;
            }
            return System.currentTimeMillis();
        }
    }

    public Optional<String> getStringContent() {
        return MessageHelper.getStringContent(this);
    }

    @Override
    public String toString() {
        return String.format("(OutboundMessage[%s]: %s)", this.getItemId(), this.getStringContent());
    }

    public static StatusKind getStatusKind(OutboundMessageGenerated.Status status) {
        return switch (status) {
            default -> throw new MatchException(null, null);
            case OutboundMessageGenerated.Status.FAILED, OutboundMessageGenerated.Status.UNDELIVERED, OutboundMessageGenerated.Status.NO_CONTACT_RECIPIENTS, OutboundMessageGenerated.Status.DRAFT, OutboundMessageGenerated.Status.UNPROCESSED -> StatusKind.NONE;
            case OutboundMessageGenerated.Status.PROCESSING, OutboundMessageGenerated.Status.SENT -> StatusKind.ANY_RECIPIENT;
            case OutboundMessageGenerated.Status.DELIVERED, OutboundMessageGenerated.Status.DELIVERED_AND_READ -> StatusKind.ONE_RECIPIENT;
            case OutboundMessageGenerated.Status.PARTIALLY_DELIVERED_PARTIALLY_READ, OutboundMessageGenerated.Status.PARTIALLY_DELIVERED_NOT_READ, OutboundMessageGenerated.Status.FULLY_DELIVERED_NOT_READ, OutboundMessageGenerated.Status.FULLY_DELIVERED_PARTIALLY_READ, OutboundMessageGenerated.Status.FULLY_DELIVERED_FULLY_READ -> StatusKind.MULTIPLE_RECIPIENTS;
        };
    }

    public static enum StatusKind {
        NONE,
        ANY_RECIPIENT,
        ONE_RECIPIENT,
        MULTIPLE_RECIPIENTS;

    }
}

