/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables.message;

import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.misc.Either;
import java.util.Optional;

public class MessageEditionState {
    public final Either<Id<OutboundMessage>, Id<OwnedMessage>> id;
    private String modifiedBody;

    private MessageEditionState(Either<Id<OutboundMessage>, Id<OwnedMessage>> id) {
        this.id = id;
    }

    public static MessageEditionState ofOutbound(Id<OutboundMessage> id) {
        return new MessageEditionState(Either.left(id));
    }

    public static MessageEditionState ofOwned(Id<OwnedMessage> id) {
        return new MessageEditionState(Either.right(id));
    }

    public Id<? extends AbstractUserMessageGenerated<?>> getItemId() {
        if (this.id.isLeft()) {
            return this.id.getLeft();
        }
        return this.id.getRight();
    }

    public Optional<String> getModifiedBody() {
        return Optional.ofNullable(this.modifiedBody);
    }

    public void setModifyBody(String modifyBody) {
        this.modifiedBody = modifyBody;
    }

    public String toString() {
        return "MessageEditionState{id=" + String.valueOf(this.id) + ", modifiedBody='" + this.modifiedBody + "'}";
    }
}

