/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables.gen.reaction;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractReactionGenerated<T extends AbstractReactionGenerated<T>>
extends AbstractTableGenerated<T>
implements Table {
    private static final String FK_SENDER_NAME = "fk_sender";
    public static final Column.ForeignColumn<AbstractReactionGenerated<?>, IdentityRef> FK_SENDER = new Column.ForeignColumn("fk_sender", false);
    private static final String EMOJI_NAME = "emoji";
    public static final Column.ObjectColumn<AbstractReactionGenerated<?>, String> EMOJI = new Column.ObjectColumn("emoji", true);
    private static final String TIMESTAMP_NAME = "timestamp";
    public static final Column.longColumn<AbstractReactionGenerated<?>> TIMESTAMP = new Column.longColumn("timestamp");
    public static final List<String> ALL_FIELDS;
    @DatabaseField(columnName="fk_sender", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_sender NOT NULL REFERENCES identity_ref_table(gen_id)")
    protected IdentityRef fkSender;
    @DatabaseField(columnName="emoji", dataType=DataType.STRING)
    protected String emoji;
    @DatabaseField(columnName="timestamp", dataType=DataType.LONG)
    protected long timestamp;

    public AbstractReactionGenerated() {
    }

    protected AbstractReactionGenerated(long genId) {
        super(genId);
    }

    protected AbstractReactionGenerated(long genId, IdentityRef sender, String emoji, long timestamp) {
        super(genId);
        this.fkSender = sender;
        this.emoji = emoji;
        this.timestamp = timestamp;
    }

    public Id<IdentityRef> getSenderId() {
        return this.fkSender.getItemId();
    }

    public Optional<String> getEmoji() {
        return Optional.ofNullable(this.emoji);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return String.format("AbstractReaction[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        AbstractReactionGenerated casted = (AbstractReactionGenerated)this.getClazz().cast(obj);
        return Objects.equals(this.fkSender, casted.fkSender) && Objects.equals(this.emoji, casted.emoji) && this.timestamp == casted.timestamp;
    }

    static {
        ArrayList<String> fields = new ArrayList<String>(AbstractTableGenerated.ALL_FIELDS);
        fields.add(FK_SENDER_NAME);
        fields.add(EMOJI_NAME);
        fields.add(TIMESTAMP_NAME);
        ALL_FIELDS = List.copyOf(fields);
    }
}

