/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables.gen.message;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Location;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.MessageRef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public abstract class ReceivedMessageGenerated<T extends ReceivedMessageGenerated<T>>
extends AbstractUserMessageGenerated<T>
implements Table {
    private static final String RETURN_RECEIPT_NONCE_NAME = "return_receipt_nonce";
    public static final Column.ObjectColumn<ReceivedMessageGenerated<?>, byte[]> RETURN_RECEIPT_NONCE = new Column.ObjectColumn("return_receipt_nonce", false);
    private static final String RETURN_RECEIPT_KEY_NAME = "return_receipt_key";
    public static final Column.ObjectColumn<ReceivedMessageGenerated<?>, byte[]> RETURN_RECEIPT_KEY = new Column.ObjectColumn("return_receipt_key", false);
    private static final String ENGINE_MESSAGE_IDENTIFIER_NAME = "engine_message_identifier";
    public static final Column.ObjectColumn<ReceivedMessageGenerated<?>, byte[]> ENGINE_MESSAGE_IDENTIFIER = new Column.ObjectColumn("engine_message_identifier", false);
    private static final String MISSED_MESSAGE_COUNT_NAME = "missed_message_count";
    public static final Column.longColumn<ReceivedMessageGenerated<?>> MISSED_MESSAGE_COUNT = new Column.longColumn("missed_message_count");
    public static final List<String> ALL_FIELDS;
    public static final List<String> MAP_ROW_FIELDS;
    public static final List<Column<? super ReceivedMessageGenerated<?>>> MAP_ROW_COLUMNS;
    @DatabaseField(columnName="return_receipt_nonce", canBeNull=false, dataType=DataType.BYTE_ARRAY)
    protected byte[] returnReceiptNonce;
    @DatabaseField(columnName="return_receipt_key", canBeNull=false, dataType=DataType.BYTE_ARRAY)
    protected byte[] returnReceiptKey;
    @DatabaseField(columnName="engine_message_identifier", index=true, canBeNull=false, dataType=DataType.BYTE_ARRAY)
    protected byte[] engineMessageIdentifier;
    @DatabaseField(columnName="missed_message_count", dataType=DataType.LONG)
    protected long missedMessageCount;

    public ReceivedMessageGenerated() {
    }

    protected ReceivedMessageGenerated(long genId) {
        super(genId);
    }

    protected ReceivedMessageGenerated(long genId, Discussion discussion, long senderSequenceNumber, double sortIndex, long timestamp, String body, MessageRef replyTo, Location location, AbstractUserMessageGenerated.WipeStatus wipeStatus, UUID senderThreadIdentifier, int totalAttachmentCount, int imageCount, AbstractUserMessageGenerated.LinkPreviewKind linkPreviewKind, String linkPreviewDescription, Double linkPreviewImageWidth, AbstractUserMessageGenerated.EditionStatus editionStatus, boolean forwarded, byte[] returnReceiptNonce, byte[] returnReceiptKey, byte[] engineMessageIdentifier, long missedMessageCount) {
        super(genId, discussion, senderSequenceNumber, sortIndex, timestamp, body, replyTo, location, wipeStatus, senderThreadIdentifier, totalAttachmentCount, imageCount, linkPreviewKind, linkPreviewDescription, linkPreviewImageWidth, editionStatus, forwarded);
        this.returnReceiptNonce = returnReceiptNonce;
        this.returnReceiptKey = returnReceiptKey;
        this.engineMessageIdentifier = engineMessageIdentifier;
        this.missedMessageCount = missedMessageCount;
    }

    public byte[] getReturnReceiptNonce() {
        return this.returnReceiptNonce;
    }

    public byte[] getReturnReceiptKey() {
        return this.returnReceiptKey;
    }

    public byte[] getEngineMessageIdentifier() {
        return this.engineMessageIdentifier;
    }

    public long getMissedMessageCount() {
        return this.missedMessageCount;
    }

    @Override
    public String toString() {
        return String.format("ReceivedMessage[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        ReceivedMessageGenerated casted = (ReceivedMessageGenerated)this.getClazz().cast(obj);
        return super.areContentTheSame(obj) && Arrays.equals(this.returnReceiptNonce, casted.returnReceiptNonce) && Arrays.equals(this.returnReceiptKey, casted.returnReceiptKey) && Arrays.equals(this.engineMessageIdentifier, casted.engineMessageIdentifier) && this.missedMessageCount == casted.missedMessageCount;
    }

    static {
        ArrayList<String> fields = new ArrayList<String>(AbstractUserMessageGenerated.ALL_FIELDS);
        fields.add(RETURN_RECEIPT_NONCE_NAME);
        fields.add(RETURN_RECEIPT_KEY_NAME);
        fields.add(ENGINE_MESSAGE_IDENTIFIER_NAME);
        fields.add(MISSED_MESSAGE_COUNT_NAME);
        ALL_FIELDS = List.copyOf(fields);
        fields = new ArrayList<String>(AbstractUserMessageGenerated.MAP_ROW_FIELDS);
        fields.add(MISSED_MESSAGE_COUNT_NAME);
        MAP_ROW_FIELDS = List.copyOf(fields);
        ArrayList columns = new ArrayList();
        columns.addAll(AbstractUserMessageGenerated.MAP_ROW_COLUMNS);
        columns.add(MISSED_MESSAGE_COUNT);
        MAP_ROW_COLUMNS = List.copyOf(columns);
    }

    public static interface Interface<T extends AbstractUserMessageGenerated<T>>
    extends AbstractUserMessageGenerated.Interface<T> {
        @Override
        public Id<T> getItemId();

        @Override
        public Id<Discussion> getDiscussionId();

        @Override
        public long getSenderSequenceNumber();

        @Override
        public double getSortIndex();

        @Override
        public long getTimestamp();

        @Override
        public Optional<String> getBody();

        @Override
        public Optional<Id<MessageRef>> getReplyToId();

        @Override
        public Optional<Id<Location>> getLocationId();

        @Override
        public AbstractUserMessageGenerated.WipeStatus getWipeStatus();

        @Override
        public int getTotalAttachmentCount();

        @Override
        public int getImageCount();

        @Override
        public AbstractUserMessageGenerated.LinkPreviewKind getLinkPreviewKind();

        @Override
        public Optional<String> getLinkPreviewDescription();

        @Override
        public Optional<Double> getLinkPreviewImageWidth();

        @Override
        public AbstractUserMessageGenerated.EditionStatus getEditionStatus();

        @Override
        public boolean isForwarded();

        public long getMissedMessageCount();
    }
}

