/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables.gen.message;

import com.j256.ormlite.field.DatabaseField;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.TableReference;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.PendingMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class PendingMessageGenerated<T extends PendingMessageGenerated<T>>
extends AbstractTableGenerated<T>
implements Table {
    public static final String TABLE_NAME = "pending_message_table";
    private static final String FK_DISCUSSION_NAME = "fk_discussion";
    public static final Column.ForeignColumn<PendingMessage, Discussion> FK_DISCUSSION = new Column.ForeignColumn("fk_discussion", false);
    private static final String FK_MESSAGE_NAME = "fk_message";
    public static final Column.ForeignColumn<PendingMessage, OutboundMessage> FK_MESSAGE = new Column.ForeignColumn("fk_message", false);
    private static final String FK_CONTACT_REF_NAME = "fk_contact_ref";
    public static final Column.ForeignColumn<PendingMessage, ContactRef> FK_CONTACT_REF = new Column.ForeignColumn("fk_contact_ref", false);
    public static final List<String> ALL_FIELDS;
    @DatabaseField(columnName="fk_discussion", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_discussion NOT NULL REFERENCES discussion_table(gen_id) ON DELETE CASCADE")
    protected Discussion fkDiscussion;
    @DatabaseField(columnName="fk_message", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_message NOT NULL REFERENCES outbound_message_table(gen_id) ON DELETE CASCADE")
    protected OutboundMessage fkMessage;
    @DatabaseField(columnName="fk_contact_ref", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_contact_ref NOT NULL REFERENCES contact_ref_table(gen_id) ON DELETE CASCADE")
    protected ContactRef fkContactRef;
    public static final List<TableReference<?, PendingMessage>> references;

    public PendingMessageGenerated() {
    }

    public PendingMessageGenerated(long genId) {
        super(genId);
    }

    public PendingMessageGenerated(long genId, Discussion discussion, OutboundMessage message, ContactRef contactRef) {
        super(genId);
        this.fkDiscussion = discussion;
        this.fkMessage = message;
        this.fkContactRef = contactRef;
    }

    public Id<Discussion> getDiscussionId() {
        return this.fkDiscussion.getItemId();
    }

    public Id<OutboundMessage> getMessageId() {
        return this.fkMessage.getItemId();
    }

    public Id<ContactRef> getContactRefId() {
        return this.fkContactRef.getItemId();
    }

    public String toString() {
        return String.format("PendingMessage[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        PendingMessageGenerated casted = (PendingMessageGenerated)this.getClazz().cast(obj);
        return Objects.equals(this.fkDiscussion, casted.fkDiscussion) && Objects.equals(this.fkMessage, casted.fkMessage) && Objects.equals(this.fkContactRef, casted.fkContactRef);
    }

    static {
        ArrayList<String> fields = new ArrayList<String>(AbstractTableGenerated.ALL_FIELDS);
        fields.add(FK_DISCUSSION_NAME);
        fields.add(FK_MESSAGE_NAME);
        fields.add(FK_CONTACT_REF_NAME);
        ALL_FIELDS = List.copyOf(fields);
        references = List.of();
    }
}

