/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables.gen.message;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.support.DatabaseResults;
import io.olvid.windows.messenger.database.annotations.ExtraStatements;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Location;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.TableReference;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.ephemerality.OutboundMessageEphemeralInfo;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.MessageRecipientInfo;
import io.olvid.windows.messenger.database.tables.message.MessageRef;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.PendingMessage;
import io.olvid.windows.messenger.database.tables.metadata.OutboundMessageMetadata;
import io.olvid.windows.messenger.database.tables.reaction.OutboundMessageReaction;
import io.olvid.windows.messenger.fx.misc.IComparable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public abstract class OutboundMessageGenerated<T extends OutboundMessageGenerated<T>>
extends AbstractUserMessageGenerated<T>
implements Table {
    public static final String TABLE_NAME = "outbound_message_table";
    private static final String CREATE_VIRTUAL_STATEMENT = "CREATE VIRTUAL TABLE IF NOT EXISTS outbound_message_table_fts USING fts5(`body`, tokenize=\"unicode61 remove_diacritics 2\", content='outbound_message_table', content_rowid='gen_id');";
    private static final String AFTER_CREATE_STATEMENT = "CREATE TRIGGER IF NOT EXISTS outbound_message_table_ai AFTER INSERT ON outbound_message_table BEGIN  INSERT INTO outbound_message_table_fts (`rowid`, `body`) VALUES (new.`gen_id`, new.`body`); END;";
    private static final String AFTER_UPDATE_STATEMENT = "CREATE TRIGGER IF NOT EXISTS outbound_message_table_au AFTER UPDATE ON outbound_message_table FOR EACH ROW  WHEN  ( new.body IS NOT old.body ) BEGIN  INSERT INTO outbound_message_table_fts (`outbound_message_table_fts`, `rowid`, `body`) VALUES ('delete', old.`gen_id`, old.`body`); INSERT INTO outbound_message_table_fts (`rowid`, `body`) VALUES (new.`gen_id`, new.`body`); END; ";
    private static final String AFTER_DELETE_STATEMENT = "CREATE TRIGGER IF NOT EXISTS outbound_message_table_ad AFTER DELETE ON outbound_message_table BEGIN  INSERT INTO outbound_message_table_fts (`outbound_message_table_fts`, `rowid`, `body`) VALUES ('delete', old.`gen_id`, old.`body`); END;";
    private static final String FK_OUTBOUND_MESSAGE_EPHEMERAL_INFO_NAME = "fk_outbound_message_ephemeral_info";
    public static final Column.ForeignColumn<OutboundMessage, OutboundMessageEphemeralInfo> FK_OUTBOUND_MESSAGE_EPHEMERAL_INFO = new Column.ForeignColumn("fk_outbound_message_ephemeral_info", true);
    private static final String STATUS_NAME = "status";
    public static final Column.ObjectColumn<OutboundMessage, Status> STATUS = new Column.ObjectColumn("status", false);
    @ExtraStatements
    public static final List<String> ALL_VIRTUAL_TABLE_EXTRA_STATEMENTS;
    public static final List<String> ALL_FIELDS;
    public static final List<String> MAP_ROW_FIELDS;
    public static final List<Column<? super OutboundMessage>> MAP_ROW_COLUMNS;
    @DatabaseField(columnName="fk_outbound_message_ephemeral_info", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_outbound_message_ephemeral_info REFERENCES outbound_message_ephemeral_info_table(gen_id) ON DELETE SET NULL")
    protected OutboundMessageEphemeralInfo fkOutboundMessageEphemeralInfo;
    @DatabaseField(columnName="status", canBeNull=false, dataType=DataType.ENUM_NAME)
    protected Status status;
    public static final List<TableReference<?, OutboundMessage>> references;

    public OutboundMessageGenerated() {
    }

    public OutboundMessageGenerated(long genId) {
        super(genId);
    }

    public OutboundMessageGenerated(long genId, Discussion discussion, long senderSequenceNumber, double sortIndex, long timestamp, String body, MessageRef replyTo, Location location, AbstractUserMessageGenerated.WipeStatus wipeStatus, UUID senderThreadIdentifier, int totalAttachmentCount, int imageCount, AbstractUserMessageGenerated.LinkPreviewKind linkPreviewKind, String linkPreviewDescription, Double linkPreviewImageWidth, AbstractUserMessageGenerated.EditionStatus editionStatus, boolean forwarded, OutboundMessageEphemeralInfo outboundMessageEphemeralInfo, Status status) {
        super(genId, discussion, senderSequenceNumber, sortIndex, timestamp, body, replyTo, location, wipeStatus, senderThreadIdentifier, totalAttachmentCount, imageCount, linkPreviewKind, linkPreviewDescription, linkPreviewImageWidth, editionStatus, forwarded);
        this.fkOutboundMessageEphemeralInfo = outboundMessageEphemeralInfo;
        this.status = status;
    }

    public Optional<Id<OutboundMessageEphemeralInfo>> getOutboundMessageEphemeralInfoId() {
        return Optional.ofNullable(this.fkOutboundMessageEphemeralInfo).map(AbstractTableGenerated::getItemId);
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @Override
    public String toString() {
        return String.format("OutboundMessage[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        OutboundMessageGenerated casted = (OutboundMessageGenerated)this.getClazz().cast(obj);
        return super.areContentTheSame(obj) && Objects.equals(this.fkOutboundMessageEphemeralInfo, casted.fkOutboundMessageEphemeralInfo) && this.status == casted.status;
    }

    public static Interface mapRow(DatabaseResults databaseResults, String prefix) throws SQLException {
        long genId_ = AbstractTableGenerated.getLong(databaseResults, GEN_ID, prefix);
        Id<OutboundMessage> genId = new Id<OutboundMessage>(OutboundMessage.class, genId_);
        long discussionId = AbstractTableGenerated.getLong(databaseResults, FK_DISCUSSION, prefix);
        Id<Discussion> discussion = new Id<Discussion>(Discussion.class, discussionId);
        long senderSequenceNumber = AbstractTableGenerated.getLong(databaseResults, SENDER_SEQUENCE_NUMBER, prefix);
        double sortIndex = AbstractTableGenerated.getDouble(databaseResults, SORT_INDEX, prefix);
        long timestamp = AbstractTableGenerated.getLong(databaseResults, TIMESTAMP, prefix);
        String body = AbstractTableGenerated.getStringObj(databaseResults, BODY, prefix);
        Long replyToId = AbstractTableGenerated.getLongObj(databaseResults, FK_REPLY_TO, prefix);
        Optional<Object> replyTo = replyToId == null ? Optional.empty() : Optional.of(new Id<MessageRef>(MessageRef.class, replyToId));
        Long locationId = AbstractTableGenerated.getLongObj(databaseResults, FK_LOCATION, prefix);
        Optional<Object> location = locationId == null ? Optional.empty() : Optional.of(new Id<Location>(Location.class, locationId));
        String wipeStatusAsString = AbstractTableGenerated.getEnumName(databaseResults, WIPE_STATUS, prefix);
        AbstractUserMessageGenerated.WipeStatus wipeStatus = AbstractUserMessageGenerated.WipeStatus.valueOf(wipeStatusAsString);
        int totalAttachmentCount = AbstractTableGenerated.getInt(databaseResults, TOTAL_ATTACHMENT_COUNT, prefix);
        int imageCount = AbstractTableGenerated.getInt(databaseResults, IMAGE_COUNT, prefix);
        String linkPreviewKindAsString = AbstractTableGenerated.getEnumName(databaseResults, LINK_PREVIEW_KIND, prefix);
        AbstractUserMessageGenerated.LinkPreviewKind linkPreviewKind = AbstractUserMessageGenerated.LinkPreviewKind.valueOf(linkPreviewKindAsString);
        String linkPreviewDescription = AbstractTableGenerated.getStringObj(databaseResults, LINK_PREVIEW_DESCRIPTION, prefix);
        Double linkPreviewImageWidth = AbstractTableGenerated.getDoubleObj(databaseResults, LINK_PREVIEW_IMAGE_WIDTH, prefix);
        String editionStatusAsString = AbstractTableGenerated.getEnumName(databaseResults, EDITION_STATUS, prefix);
        AbstractUserMessageGenerated.EditionStatus editionStatus = AbstractUserMessageGenerated.EditionStatus.valueOf(editionStatusAsString);
        boolean forwarded = AbstractTableGenerated.getBoolean(databaseResults, FORWARDED, prefix);
        Long outboundMessageEphemeralInfoId = AbstractTableGenerated.getLongObj(databaseResults, FK_OUTBOUND_MESSAGE_EPHEMERAL_INFO, prefix);
        Optional<Object> outboundMessageEphemeralInfo = outboundMessageEphemeralInfoId == null ? Optional.empty() : Optional.of(new Id<OutboundMessageEphemeralInfo>(OutboundMessageEphemeralInfo.class, outboundMessageEphemeralInfoId));
        String statusAsString = AbstractTableGenerated.getEnumName(databaseResults, STATUS, prefix);
        Status status = Status.valueOf(statusAsString);
        return new Pojo(genId, discussion, senderSequenceNumber, sortIndex, timestamp, body, replyTo, location, wipeStatus, totalAttachmentCount, imageCount, linkPreviewKind, linkPreviewDescription, linkPreviewImageWidth, editionStatus, forwarded, outboundMessageEphemeralInfo, status);
    }

    static {
        ArrayList<String> statements = new ArrayList<String>();
        statements.add(CREATE_VIRTUAL_STATEMENT);
        statements.add(AFTER_CREATE_STATEMENT);
        statements.add(AFTER_UPDATE_STATEMENT);
        statements.add(AFTER_DELETE_STATEMENT);
        ALL_VIRTUAL_TABLE_EXTRA_STATEMENTS = List.copyOf(statements);
        ArrayList<String> fields = new ArrayList<String>(AbstractUserMessageGenerated.ALL_FIELDS);
        fields.add(FK_OUTBOUND_MESSAGE_EPHEMERAL_INFO_NAME);
        fields.add(STATUS_NAME);
        ALL_FIELDS = List.copyOf(fields);
        fields = new ArrayList<String>(AbstractUserMessageGenerated.MAP_ROW_FIELDS);
        fields.add(FK_OUTBOUND_MESSAGE_EPHEMERAL_INFO_NAME);
        fields.add(STATUS_NAME);
        MAP_ROW_FIELDS = List.copyOf(fields);
        ArrayList<Column<AbstractUserMessageGenerated<Object>>> columns = new ArrayList<Column<AbstractUserMessageGenerated<Object>>>();
        columns.addAll(AbstractUserMessageGenerated.MAP_ROW_COLUMNS);
        columns.add(FK_OUTBOUND_MESSAGE_EPHEMERAL_INFO);
        columns.add(STATUS);
        MAP_ROW_COLUMNS = List.copyOf(columns);
        ArrayList refs = new ArrayList();
        refs.add(new TableReference(OutboundAttachment.class, OutboundAttachment.FK_MESSAGE, x -> Optional.of(x.getMessageId())));
        refs.add(new TableReference(MessageRecipientInfo.class, MessageRecipientInfo.FK_MESSAGE, x -> Optional.of(x.getMessageId())));
        refs.add(new TableReference(MessageRef.class, MessageRef.FK_OUTBOUND_MESSAGE, x -> x.getOutboundMessageId()));
        refs.add(new TableReference(PendingMessage.class, PendingMessage.FK_MESSAGE, x -> Optional.of(x.getMessageId())));
        refs.add(new TableReference(OutboundMessageMetadata.class, OutboundMessageMetadata.FK_MESSAGE, x -> Optional.of(x.getMessageId())));
        refs.add(new TableReference(OutboundMessageReaction.class, OutboundMessageReaction.FK_MESSAGE, x -> Optional.of(x.getMessageId())));
        references = List.copyOf(refs);
    }

    public static enum Status implements IComparable<Status>
    {
        FAILED,
        UNDELIVERED,
        NO_CONTACT_RECIPIENTS,
        DRAFT,
        UNPROCESSED,
        PROCESSING,
        SENT,
        DELIVERED,
        DELIVERED_AND_READ,
        PARTIALLY_DELIVERED_NOT_READ,
        PARTIALLY_DELIVERED_PARTIALLY_READ,
        FULLY_DELIVERED_NOT_READ,
        FULLY_DELIVERED_PARTIALLY_READ,
        FULLY_DELIVERED_FULLY_READ;

    }

    private record Pojo(Id<OutboundMessage> genId, Id<Discussion> discussion, long senderSequenceNumber, double sortIndex, long timestamp, String body, Optional<Id<MessageRef>> replyTo, Optional<Id<Location>> location, AbstractUserMessageGenerated.WipeStatus wipeStatus, int totalAttachmentCount, int imageCount, AbstractUserMessageGenerated.LinkPreviewKind linkPreviewKind, String linkPreviewDescription, Double linkPreviewImageWidth, AbstractUserMessageGenerated.EditionStatus editionStatus, boolean forwarded, Optional<Id<OutboundMessageEphemeralInfo>> outboundMessageEphemeralInfo, Status status) implements Interface
    {
        @Override
        public Id<OutboundMessage> getItemId() {
            return this.genId;
        }

        @Override
        public Id<Discussion> getDiscussionId() {
            return this.discussion;
        }

        @Override
        public long getSenderSequenceNumber() {
            return this.senderSequenceNumber;
        }

        @Override
        public double getSortIndex() {
            return this.sortIndex;
        }

        @Override
        public long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public Optional<String> getBody() {
            return Optional.ofNullable(this.body);
        }

        @Override
        public Optional<Id<MessageRef>> getReplyToId() {
            return this.replyTo;
        }

        @Override
        public Optional<Id<Location>> getLocationId() {
            return this.location;
        }

        @Override
        public AbstractUserMessageGenerated.WipeStatus getWipeStatus() {
            return this.wipeStatus;
        }

        @Override
        public int getTotalAttachmentCount() {
            return this.totalAttachmentCount;
        }

        @Override
        public int getImageCount() {
            return this.imageCount;
        }

        @Override
        public AbstractUserMessageGenerated.LinkPreviewKind getLinkPreviewKind() {
            return this.linkPreviewKind;
        }

        @Override
        public Optional<String> getLinkPreviewDescription() {
            return Optional.ofNullable(this.linkPreviewDescription);
        }

        @Override
        public Optional<Double> getLinkPreviewImageWidth() {
            return Optional.ofNullable(this.linkPreviewImageWidth);
        }

        @Override
        public AbstractUserMessageGenerated.EditionStatus getEditionStatus() {
            return this.editionStatus;
        }

        @Override
        public boolean isForwarded() {
            return this.forwarded;
        }

        @Override
        public Optional<Id<OutboundMessageEphemeralInfo>> getOutboundMessageEphemeralInfoId() {
            return this.outboundMessageEphemeralInfo;
        }

        @Override
        public Status getStatus() {
            return this.status;
        }

        @Override
        public boolean areContentTheSame(Object obj) {
            return this.equals(obj);
        }
    }

    public static interface Interface
    extends AbstractUserMessageGenerated.Interface<OutboundMessage> {
        @Override
        public Id<OutboundMessage> getItemId();

        @Override
        public Id<Discussion> getDiscussionId();

        @Override
        public long getSenderSequenceNumber();

        @Override
        public double getSortIndex();

        @Override
        public long getTimestamp();

        @Override
        public Optional<String> getBody();

        @Override
        public Optional<Id<MessageRef>> getReplyToId();

        @Override
        public Optional<Id<Location>> getLocationId();

        @Override
        public AbstractUserMessageGenerated.WipeStatus getWipeStatus();

        @Override
        public int getTotalAttachmentCount();

        @Override
        public int getImageCount();

        @Override
        public AbstractUserMessageGenerated.LinkPreviewKind getLinkPreviewKind();

        @Override
        public Optional<String> getLinkPreviewDescription();

        @Override
        public Optional<Double> getLinkPreviewImageWidth();

        @Override
        public AbstractUserMessageGenerated.EditionStatus getEditionStatus();

        @Override
        public boolean isForwarded();

        public Optional<Id<OutboundMessageEphemeralInfo>> getOutboundMessageEphemeralInfoId();

        public Status getStatus();
    }
}

