/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables.gen.message;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.TableReference;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.MessageRef;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.database.tables.remoterequest.RemoteDeleteRequest;
import io.olvid.windows.messenger.database.tables.remoterequest.RemoteEditRequest;
import io.olvid.windows.messenger.database.tables.remoterequest.RemoteReactionRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public abstract class MessageRefGenerated<T extends MessageRefGenerated<T>>
extends AbstractTableGenerated<T>
implements Table {
    public static final String TABLE_NAME = "message_ref_table";
    private static final String FK_DISCUSSION_NAME = "fk_discussion";
    public static final Column.ForeignColumn<MessageRef, Discussion> FK_DISCUSSION = new Column.ForeignColumn("fk_discussion", false);
    private static final String SENDER_SEQUENCE_NUMBER_NAME = "sender_sequence_number";
    public static final Column.longColumn<MessageRef> SENDER_SEQUENCE_NUMBER = new Column.longColumn("sender_sequence_number");
    private static final String SENDER_THREAD_IDENTIFIER_NAME = "sender_thread_identifier";
    public static final Column.ObjectColumn<MessageRef, UUID> SENDER_THREAD_IDENTIFIER = new Column.ObjectColumn("sender_thread_identifier", false);
    private static final String SENDER_IDENTIFIER_NAME = "sender_identifier";
    public static final Column.ObjectColumn<MessageRef, byte[]> SENDER_IDENTIFIER = new Column.ObjectColumn("sender_identifier", false);
    private static final String MESSAGE_HAS_BEEN_RECEIVED_NAME = "message_has_been_received";
    public static final Column.booleanColumn<MessageRef> MESSAGE_HAS_BEEN_RECEIVED = new Column.booleanColumn("message_has_been_received");
    private static final String FK_OUTBOUND_MESSAGE_NAME = "fk_outbound_message";
    public static final Column.ForeignColumn<MessageRef, OutboundMessage> FK_OUTBOUND_MESSAGE = new Column.ForeignColumn("fk_outbound_message", true);
    private static final String FK_INBOUND_MESSAGE_NAME = "fk_inbound_message";
    public static final Column.ForeignColumn<MessageRef, InboundMessage> FK_INBOUND_MESSAGE = new Column.ForeignColumn("fk_inbound_message", true);
    private static final String FK_OWNED_MESSAGE_NAME = "fk_owned_message";
    public static final Column.ForeignColumn<MessageRef, OwnedMessage> FK_OWNED_MESSAGE = new Column.ForeignColumn("fk_owned_message", true);
    public static final List<String> ALL_FIELDS;
    @DatabaseField(columnName="fk_discussion", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_discussion NOT NULL REFERENCES discussion_table(gen_id) ON DELETE CASCADE")
    protected Discussion fkDiscussion;
    @DatabaseField(columnName="sender_sequence_number", uniqueCombo=true, dataType=DataType.LONG)
    protected long senderSequenceNumber;
    @DatabaseField(columnName="sender_thread_identifier", uniqueCombo=true, canBeNull=false, dataType=DataType.UUID)
    protected UUID senderThreadIdentifier;
    @DatabaseField(columnName="sender_identifier", uniqueCombo=true, canBeNull=false, dataType=DataType.BYTE_ARRAY)
    protected byte[] senderIdentifier;
    @DatabaseField(columnName="message_has_been_received", dataType=DataType.BOOLEAN)
    protected boolean messageHasBeenReceived;
    @DatabaseField(columnName="fk_outbound_message", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_outbound_message UNIQUE REFERENCES outbound_message_table(gen_id) ON DELETE SET NULL")
    protected OutboundMessage fkOutboundMessage;
    @DatabaseField(columnName="fk_inbound_message", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_inbound_message UNIQUE REFERENCES inbound_message_table(gen_id) ON DELETE SET NULL")
    protected InboundMessage fkInboundMessage;
    @DatabaseField(columnName="fk_owned_message", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_owned_message UNIQUE REFERENCES owned_message_table(gen_id) ON DELETE SET NULL")
    protected OwnedMessage fkOwnedMessage;
    public static final List<TableReference<?, MessageRef>> references;

    public MessageRefGenerated() {
    }

    public MessageRefGenerated(long genId) {
        super(genId);
    }

    public MessageRefGenerated(long genId, Discussion discussion, long senderSequenceNumber, UUID senderThreadIdentifier, byte[] senderIdentifier, boolean messageHasBeenReceived, OutboundMessage outboundMessage, InboundMessage inboundMessage, OwnedMessage ownedMessage) {
        super(genId);
        this.fkDiscussion = discussion;
        this.senderSequenceNumber = senderSequenceNumber;
        this.senderThreadIdentifier = senderThreadIdentifier;
        this.senderIdentifier = senderIdentifier;
        this.messageHasBeenReceived = messageHasBeenReceived;
        this.fkOutboundMessage = outboundMessage;
        this.fkInboundMessage = inboundMessage;
        this.fkOwnedMessage = ownedMessage;
    }

    public Id<Discussion> getDiscussionId() {
        return this.fkDiscussion.getItemId();
    }

    public long getSenderSequenceNumber() {
        return this.senderSequenceNumber;
    }

    public UUID getSenderThreadIdentifier() {
        return this.senderThreadIdentifier;
    }

    public byte[] getSenderIdentifier() {
        return this.senderIdentifier;
    }

    public boolean isMessageHasBeenReceived() {
        return this.messageHasBeenReceived;
    }

    public Optional<Id<OutboundMessage>> getOutboundMessageId() {
        return Optional.ofNullable(this.fkOutboundMessage).map(AbstractTableGenerated::getItemId);
    }

    public Optional<Id<InboundMessage>> getInboundMessageId() {
        return Optional.ofNullable(this.fkInboundMessage).map(AbstractTableGenerated::getItemId);
    }

    public Optional<Id<OwnedMessage>> getOwnedMessageId() {
        return Optional.ofNullable(this.fkOwnedMessage).map(AbstractTableGenerated::getItemId);
    }

    public String toString() {
        return String.format("MessageRef[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        MessageRefGenerated casted = (MessageRefGenerated)this.getClazz().cast(obj);
        return Objects.equals(this.fkDiscussion, casted.fkDiscussion) && this.senderSequenceNumber == casted.senderSequenceNumber && Objects.equals(this.senderThreadIdentifier, casted.senderThreadIdentifier) && Arrays.equals(this.senderIdentifier, casted.senderIdentifier) && this.messageHasBeenReceived == casted.messageHasBeenReceived && Objects.equals(this.fkOutboundMessage, casted.fkOutboundMessage) && Objects.equals(this.fkInboundMessage, casted.fkInboundMessage) && Objects.equals(this.fkOwnedMessage, casted.fkOwnedMessage);
    }

    static {
        ArrayList<String> fields = new ArrayList<String>(AbstractTableGenerated.ALL_FIELDS);
        fields.add(FK_DISCUSSION_NAME);
        fields.add(SENDER_SEQUENCE_NUMBER_NAME);
        fields.add(SENDER_THREAD_IDENTIFIER_NAME);
        fields.add(SENDER_IDENTIFIER_NAME);
        fields.add(MESSAGE_HAS_BEEN_RECEIVED_NAME);
        fields.add(FK_OUTBOUND_MESSAGE_NAME);
        fields.add(FK_INBOUND_MESSAGE_NAME);
        fields.add(FK_OWNED_MESSAGE_NAME);
        ALL_FIELDS = List.copyOf(fields);
        ArrayList refs = new ArrayList();
        refs.add(new TableReference(InboundMessage.class, InboundMessage.FK_REPLY_TO, x -> x.getReplyToId()));
        refs.add(new TableReference(OwnedMessage.class, OwnedMessage.FK_REPLY_TO, x -> x.getReplyToId()));
        refs.add(new TableReference(OutboundMessage.class, OutboundMessage.FK_REPLY_TO, x -> x.getReplyToId()));
        refs.add(new TableReference(RemoteDeleteRequest.class, RemoteDeleteRequest.FK_MESSAGE_REF, x -> Optional.of(x.getMessageRefId())));
        refs.add(new TableReference(RemoteEditRequest.class, RemoteEditRequest.FK_MESSAGE_REF, x -> Optional.of(x.getMessageRefId())));
        refs.add(new TableReference(RemoteReactionRequest.class, RemoteReactionRequest.FK_MESSAGE_REF, x -> Optional.of(x.getMessageRefId())));
        refs.add(new TableReference(Discussion.class, Discussion.FK_LAST_USER_MESSAGE_REF, x -> x.getLastUserMessageRefId()));
        references = List.copyOf(refs);
    }
}

