/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables.gen.attachment;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.TableReference;
import io.olvid.windows.messenger.database.tables.attachment.AttachmentRecipientInfo;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.database.tables.message.MessageRecipientInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class AttachmentRecipientInfoGenerated<T extends AttachmentRecipientInfoGenerated<T>>
extends AbstractTableGenerated<T>
implements Table {
    public static final String TABLE_NAME = "attachment_recipient_info_table";
    private static final String FK_MESSAGE_RECIPIENT_INFO_NAME = "fk_message_recipient_info";
    public static final Column.ForeignColumn<AttachmentRecipientInfo, MessageRecipientInfo> FK_MESSAGE_RECIPIENT_INFO = new Column.ForeignColumn("fk_message_recipient_info", false);
    private static final String FK_ATTACHMENT_NAME = "fk_attachment";
    public static final Column.ForeignColumn<AttachmentRecipientInfo, OutboundAttachment> FK_ATTACHMENT = new Column.ForeignColumn("fk_attachment", false);
    private static final String ENGINE_MESSAGE_IDENTIFIER_NAME = "engine_message_identifier";
    public static final Column.ObjectColumn<AttachmentRecipientInfo, byte[]> ENGINE_MESSAGE_IDENTIFIER = new Column.ObjectColumn("engine_message_identifier", false);
    private static final String TIMESTAMP_CANCELLED_NAME = "timestamp_cancelled";
    public static final Column.ObjectColumn<AttachmentRecipientInfo, Long> TIMESTAMP_CANCELLED = new Column.ObjectColumn("timestamp_cancelled", true);
    private static final String TIMESTAMP_SENT_NAME = "timestamp_sent";
    public static final Column.ObjectColumn<AttachmentRecipientInfo, Long> TIMESTAMP_SENT = new Column.ObjectColumn("timestamp_sent", true);
    private static final String TIMESTAMP_DELIVERED_NAME = "timestamp_delivered";
    public static final Column.ObjectColumn<AttachmentRecipientInfo, Long> TIMESTAMP_DELIVERED = new Column.ObjectColumn("timestamp_delivered", true);
    private static final String TIMESTAMP_READ_NAME = "timestamp_read";
    public static final Column.ObjectColumn<AttachmentRecipientInfo, Long> TIMESTAMP_READ = new Column.ObjectColumn("timestamp_read", true);
    public static final List<String> ALL_FIELDS;
    @DatabaseField(columnName="fk_message_recipient_info", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_message_recipient_info NOT NULL REFERENCES message_recipient_info_table(gen_id) ON DELETE CASCADE")
    protected MessageRecipientInfo fkMessageRecipientInfo;
    @DatabaseField(columnName="fk_attachment", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_attachment NOT NULL REFERENCES outbound_attachment_table(gen_id) ON DELETE CASCADE")
    protected OutboundAttachment fkAttachment;
    @DatabaseField(columnName="engine_message_identifier", canBeNull=false, dataType=DataType.BYTE_ARRAY)
    protected byte[] engineMessageIdentifier;
    @DatabaseField(columnName="timestamp_cancelled", dataType=DataType.LONG_OBJ)
    protected Long timestampCancelled;
    @DatabaseField(columnName="timestamp_sent", dataType=DataType.LONG_OBJ)
    protected Long timestampSent;
    @DatabaseField(columnName="timestamp_delivered", dataType=DataType.LONG_OBJ)
    protected Long timestampDelivered;
    @DatabaseField(columnName="timestamp_read", dataType=DataType.LONG_OBJ)
    protected Long timestampRead;
    public static final List<TableReference<?, AttachmentRecipientInfo>> references;

    public AttachmentRecipientInfoGenerated() {
    }

    public AttachmentRecipientInfoGenerated(long genId) {
        super(genId);
    }

    public AttachmentRecipientInfoGenerated(long genId, MessageRecipientInfo messageRecipientInfo, OutboundAttachment attachment, byte[] engineMessageIdentifier, Long timestampCancelled, Long timestampSent, Long timestampDelivered, Long timestampRead) {
        super(genId);
        this.fkMessageRecipientInfo = messageRecipientInfo;
        this.fkAttachment = attachment;
        this.engineMessageIdentifier = engineMessageIdentifier;
        this.timestampCancelled = timestampCancelled;
        this.timestampSent = timestampSent;
        this.timestampDelivered = timestampDelivered;
        this.timestampRead = timestampRead;
    }

    public Id<MessageRecipientInfo> getMessageRecipientInfoId() {
        return this.fkMessageRecipientInfo.getItemId();
    }

    public Id<OutboundAttachment> getAttachmentId() {
        return this.fkAttachment.getItemId();
    }

    public byte[] getEngineMessageIdentifier() {
        return this.engineMessageIdentifier;
    }

    public Optional<Long> getTimestampCancelled() {
        return Optional.ofNullable(this.timestampCancelled);
    }

    public Optional<Long> getTimestampSent() {
        return Optional.ofNullable(this.timestampSent);
    }

    public void setTimestampSent(Optional<Long> timestampSent) {
        this.timestampSent = timestampSent.orElse(null);
    }

    public Optional<Long> getTimestampDelivered() {
        return Optional.ofNullable(this.timestampDelivered);
    }

    public void setTimestampDelivered(Optional<Long> timestampDelivered) {
        this.timestampDelivered = timestampDelivered.orElse(null);
    }

    public Optional<Long> getTimestampRead() {
        return Optional.ofNullable(this.timestampRead);
    }

    public void setTimestampRead(Optional<Long> timestampRead) {
        this.timestampRead = timestampRead.orElse(null);
    }

    public String toString() {
        return String.format("AttachmentRecipientInfo[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        AttachmentRecipientInfoGenerated casted = (AttachmentRecipientInfoGenerated)this.getClazz().cast(obj);
        return Objects.equals(this.fkMessageRecipientInfo, casted.fkMessageRecipientInfo) && Objects.equals(this.fkAttachment, casted.fkAttachment) && Arrays.equals(this.engineMessageIdentifier, casted.engineMessageIdentifier) && Objects.equals(this.timestampCancelled, casted.timestampCancelled) && Objects.equals(this.timestampSent, casted.timestampSent) && Objects.equals(this.timestampDelivered, casted.timestampDelivered) && Objects.equals(this.timestampRead, casted.timestampRead);
    }

    static {
        ArrayList<String> fields = new ArrayList<String>(AbstractTableGenerated.ALL_FIELDS);
        fields.add(FK_MESSAGE_RECIPIENT_INFO_NAME);
        fields.add(FK_ATTACHMENT_NAME);
        fields.add(ENGINE_MESSAGE_IDENTIFIER_NAME);
        fields.add(TIMESTAMP_CANCELLED_NAME);
        fields.add(TIMESTAMP_SENT_NAME);
        fields.add(TIMESTAMP_DELIVERED_NAME);
        fields.add(TIMESTAMP_READ_NAME);
        ALL_FIELDS = List.copyOf(fields);
        references = List.of();
    }
}

