/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables.gen;

import com.j256.ormlite.field.DatabaseField;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityDetails;
import io.olvid.windows.messenger.database.tables.PreContact;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.TableReference;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class PreContactGenerated<T extends PreContactGenerated<T>>
extends AbstractTableGenerated<T>
implements Table {
    public static final String TABLE_NAME = "pre_contact_table";
    private static final String FK_CONTACT_REF_NAME = "fk_contact_ref";
    public static final Column.ForeignColumn<PreContact, ContactRef> FK_CONTACT_REF = new Column.ForeignColumn("fk_contact_ref", false);
    private static final String FK_IDENTITY_DETAILS_NAME = "fk_identity_details";
    public static final Column.ForeignColumn<PreContact, IdentityDetails> FK_IDENTITY_DETAILS = new Column.ForeignColumn("fk_identity_details", false);
    public static final List<String> ALL_FIELDS;
    @DatabaseField(columnName="fk_contact_ref", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_contact_ref UNIQUE NOT NULL REFERENCES contact_ref_table(gen_id) ON DELETE CASCADE")
    protected ContactRef fkContactRef;
    @DatabaseField(columnName="fk_identity_details", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_identity_details UNIQUE NOT NULL REFERENCES identity_details_table(gen_id)")
    protected IdentityDetails fkIdentityDetails;
    public static final List<TableReference<?, PreContact>> references;

    public PreContactGenerated() {
    }

    public PreContactGenerated(long genId) {
        super(genId);
    }

    public PreContactGenerated(long genId, ContactRef contactRef, IdentityDetails identityDetails) {
        super(genId);
        this.fkContactRef = contactRef;
        this.fkIdentityDetails = identityDetails;
    }

    public Id<ContactRef> getContactRefId() {
        return this.fkContactRef.getItemId();
    }

    public Id<IdentityDetails> getIdentityDetailsId() {
        return this.fkIdentityDetails.getItemId();
    }

    public String toString() {
        return String.format("PreContact[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        PreContactGenerated casted = (PreContactGenerated)this.getClazz().cast(obj);
        return Objects.equals(this.fkContactRef, casted.fkContactRef) && Objects.equals(this.fkIdentityDetails, casted.fkIdentityDetails);
    }

    static {
        ArrayList<String> fields = new ArrayList<String>(AbstractTableGenerated.ALL_FIELDS);
        fields.add(FK_CONTACT_REF_NAME);
        fields.add(FK_IDENTITY_DETAILS_NAME);
        ALL_FIELDS = List.copyOf(fields);
        ArrayList refs = new ArrayList();
        refs.add(new TableReference(Discussion.class, Discussion.FK_PRE_CONTACT, x -> x.getPreContactId()));
        references = List.copyOf(refs);
    }
}

