/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables.gen;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.tables.KnownCertificate;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.TableReference;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class KnownCertificateGenerated<T extends KnownCertificateGenerated<T>>
extends AbstractTableGenerated<T>
implements Table {
    public static final String TABLE_NAME = "known_certificate_table";
    private static final String DOMAIN_NAME_NAME = "domain_name";
    public static final Column.ObjectColumn<KnownCertificate, String> DOMAIN_NAME = new Column.ObjectColumn("domain_name", false);
    private static final String CERTIFICATE_BYTES_NAME = "certificate_bytes";
    public static final Column.ObjectColumn<KnownCertificate, byte[]> CERTIFICATE_BYTES = new Column.ObjectColumn("certificate_bytes", false);
    private static final String TRUST_TIMESTAMP_NAME = "trust_timestamp";
    public static final Column.ObjectColumn<KnownCertificate, Long> TRUST_TIMESTAMP = new Column.ObjectColumn("trust_timestamp", true);
    private static final String EXPIRATION_TIMESTAMP_NAME = "expiration_timestamp";
    public static final Column.longColumn<KnownCertificate> EXPIRATION_TIMESTAMP = new Column.longColumn("expiration_timestamp");
    private static final String ISSUERS_NAME = "issuers";
    public static final Column.ObjectColumn<KnownCertificate, String> ISSUERS = new Column.ObjectColumn("issuers", false);
    private static final String ENCODED_FULL_CHAIN_NAME = "encoded_full_chain";
    public static final Column.ObjectColumn<KnownCertificate, String> ENCODED_FULL_CHAIN = new Column.ObjectColumn("encoded_full_chain", false);
    public static final List<String> ALL_FIELDS;
    @DatabaseField(columnName="domain_name", canBeNull=false, dataType=DataType.STRING)
    protected String domainName;
    @DatabaseField(columnName="certificate_bytes", canBeNull=false, dataType=DataType.BYTE_ARRAY)
    protected byte[] certificateBytes;
    @DatabaseField(columnName="trust_timestamp", dataType=DataType.LONG_OBJ)
    protected Long trustTimestamp;
    @DatabaseField(columnName="expiration_timestamp", dataType=DataType.LONG)
    protected long expirationTimestamp;
    @DatabaseField(columnName="issuers", canBeNull=false, dataType=DataType.STRING)
    protected String issuers;
    @DatabaseField(columnName="encoded_full_chain", canBeNull=false, dataType=DataType.STRING)
    protected String encodedFullChain;
    public static final List<TableReference<?, KnownCertificate>> references;

    public KnownCertificateGenerated() {
    }

    public KnownCertificateGenerated(long genId) {
        super(genId);
    }

    public KnownCertificateGenerated(long genId, String domainName, byte[] certificateBytes, Long trustTimestamp, long expirationTimestamp, String issuers, String encodedFullChain) {
        super(genId);
        this.domainName = domainName;
        this.certificateBytes = certificateBytes;
        this.trustTimestamp = trustTimestamp;
        this.expirationTimestamp = expirationTimestamp;
        this.issuers = issuers;
        this.encodedFullChain = encodedFullChain;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public byte[] getCertificateBytes() {
        return this.certificateBytes;
    }

    public Optional<Long> getTrustTimestamp() {
        return Optional.ofNullable(this.trustTimestamp);
    }

    public long getExpirationTimestamp() {
        return this.expirationTimestamp;
    }

    public String getIssuers() {
        return this.issuers;
    }

    public String getEncodedFullChain() {
        return this.encodedFullChain;
    }

    public String toString() {
        return String.format("KnownCertificate[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        KnownCertificateGenerated casted = (KnownCertificateGenerated)this.getClazz().cast(obj);
        return Objects.equals(this.domainName, casted.domainName) && Arrays.equals(this.certificateBytes, casted.certificateBytes) && Objects.equals(this.trustTimestamp, casted.trustTimestamp) && this.expirationTimestamp == casted.expirationTimestamp && Objects.equals(this.issuers, casted.issuers) && Objects.equals(this.encodedFullChain, casted.encodedFullChain);
    }

    static {
        ArrayList<String> fields = new ArrayList<String>(AbstractTableGenerated.ALL_FIELDS);
        fields.add(DOMAIN_NAME_NAME);
        fields.add(CERTIFICATE_BYTES_NAME);
        fields.add(TRUST_TIMESTAMP_NAME);
        fields.add(EXPIRATION_TIMESTAMP_NAME);
        fields.add(ISSUERS_NAME);
        fields.add(ENCODED_FULL_CHAIN_NAME);
        ALL_FIELDS = List.copyOf(fields);
        references = List.of();
    }
}

