/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables.gen;

import com.j256.ormlite.field.DatabaseField;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.TableReference;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.database.tables.message.MessageRecipientInfo;
import io.olvid.windows.messenger.database.tables.message.SystemMessage;
import io.olvid.windows.messenger.database.tables.metadata.InboundMessageMetadata;
import io.olvid.windows.messenger.database.tables.metadata.OutboundMessageMetadata;
import io.olvid.windows.messenger.database.tables.metadata.OwnedMessageMetadata;
import io.olvid.windows.messenger.database.tables.reaction.InboundMessageReaction;
import io.olvid.windows.messenger.database.tables.reaction.OutboundMessageReaction;
import io.olvid.windows.messenger.database.tables.reaction.OwnedMessageReaction;
import io.olvid.windows.messenger.database.tables.remoterequest.RemoteDeleteRequest;
import io.olvid.windows.messenger.database.tables.remoterequest.RemoteEditRequest;
import io.olvid.windows.messenger.database.tables.remoterequest.RemoteReactionRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class IdentityRefGenerated<T extends IdentityRefGenerated<T>>
extends AbstractTableGenerated<T>
implements Table {
    public static final String TABLE_NAME = "identity_ref_table";
    private static final String FK_OWNED_IDENTITY_NAME = "fk_owned_identity";
    public static final Column.ForeignColumn<IdentityRef, OwnedIdentity> FK_OWNED_IDENTITY = new Column.ForeignColumn("fk_owned_identity", true);
    private static final String FK_CONTACT_REF_NAME = "fk_contact_ref";
    public static final Column.ForeignColumn<IdentityRef, ContactRef> FK_CONTACT_REF = new Column.ForeignColumn("fk_contact_ref", true);
    public static final List<String> ALL_FIELDS;
    @DatabaseField(columnName="fk_owned_identity", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_owned_identity UNIQUE REFERENCES owned_identity_table(gen_id) ON DELETE CASCADE")
    protected OwnedIdentity fkOwnedIdentity;
    @DatabaseField(columnName="fk_contact_ref", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_contact_ref UNIQUE REFERENCES contact_ref_table(gen_id) ON DELETE CASCADE")
    protected ContactRef fkContactRef;
    public static final List<TableReference<?, IdentityRef>> references;

    public IdentityRefGenerated() {
    }

    public IdentityRefGenerated(long genId) {
        super(genId);
    }

    public IdentityRefGenerated(long genId, OwnedIdentity ownedIdentity, ContactRef contactRef) {
        super(genId);
        this.fkOwnedIdentity = ownedIdentity;
        this.fkContactRef = contactRef;
    }

    public Optional<Id<OwnedIdentity>> getOwnedIdentityId() {
        return Optional.ofNullable(this.fkOwnedIdentity).map(AbstractTableGenerated::getItemId);
    }

    public Optional<Id<ContactRef>> getContactRefId() {
        return Optional.ofNullable(this.fkContactRef).map(AbstractTableGenerated::getItemId);
    }

    public String toString() {
        return String.format("IdentityRef[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        IdentityRefGenerated casted = (IdentityRefGenerated)this.getClazz().cast(obj);
        return Objects.equals(this.fkOwnedIdentity, casted.fkOwnedIdentity) && Objects.equals(this.fkContactRef, casted.fkContactRef);
    }

    static {
        ArrayList<String> fields = new ArrayList<String>(AbstractTableGenerated.ALL_FIELDS);
        fields.add(FK_OWNED_IDENTITY_NAME);
        fields.add(FK_CONTACT_REF_NAME);
        ALL_FIELDS = List.copyOf(fields);
        ArrayList refs = new ArrayList();
        refs.add(new TableReference(SystemMessage.class, SystemMessage.FK_IDENTITY_REF, x -> x.getIdentityRefId()));
        refs.add(new TableReference(MessageRecipientInfo.class, MessageRecipientInfo.FK_RECIPIENT_REF, x -> Optional.of(x.getRecipientRefId())));
        refs.add(new TableReference(InboundMessageMetadata.class, InboundMessageMetadata.FK_DELETER, x -> x.getDeleterId()));
        refs.add(new TableReference(OutboundMessageMetadata.class, OutboundMessageMetadata.FK_DELETER, x -> x.getDeleterId()));
        refs.add(new TableReference(OwnedMessageMetadata.class, OwnedMessageMetadata.FK_DELETER, x -> x.getDeleterId()));
        refs.add(new TableReference(InboundMessageReaction.class, InboundMessageReaction.FK_SENDER, x -> Optional.of(x.getSenderId())));
        refs.add(new TableReference(OutboundMessageReaction.class, OutboundMessageReaction.FK_SENDER, x -> Optional.of(x.getSenderId())));
        refs.add(new TableReference(OwnedMessageReaction.class, OwnedMessageReaction.FK_SENDER, x -> Optional.of(x.getSenderId())));
        refs.add(new TableReference(RemoteDeleteRequest.class, RemoteDeleteRequest.FK_IDENTITY_REF, x -> Optional.of(x.getIdentityRefId())));
        refs.add(new TableReference(RemoteEditRequest.class, RemoteEditRequest.FK_IDENTITY_REF, x -> Optional.of(x.getIdentityRefId())));
        refs.add(new TableReference(RemoteReactionRequest.class, RemoteReactionRequest.FK_IDENTITY_REF, x -> Optional.of(x.getIdentityRefId())));
        references = List.copyOf(refs);
    }
}

