/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables.gen;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.tables.Fyle;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.TableReference;
import io.olvid.windows.messenger.database.tables.attachment.InboundAttachment;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.attachment.OwnedAttachment;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class FyleGenerated<T extends FyleGenerated<T>>
extends AbstractTableGenerated<T>
implements Table {
    public static final String TABLE_NAME = "fyle_table";
    private static final String FILE_PATH_NAME = "file_path";
    public static final Column.ObjectColumn<Fyle, String> FILE_PATH = new Column.ObjectColumn("file_path", false);
    private static final String SHA256_NAME = "sha256";
    public static final Column.ObjectColumn<Fyle, byte[]> SHA256 = new Column.ObjectColumn("sha256", true);
    public static final List<String> ALL_FIELDS;
    @DatabaseField(columnName="file_path", canBeNull=false, dataType=DataType.STRING)
    protected String filePath;
    @DatabaseField(columnName="sha256", unique=true, dataType=DataType.BYTE_ARRAY)
    protected byte[] sha256;
    public static final List<TableReference<?, Fyle>> references;

    public FyleGenerated() {
    }

    public FyleGenerated(long genId) {
        super(genId);
    }

    public FyleGenerated(long genId, String filePath, byte[] sha256) {
        super(genId);
        this.filePath = filePath;
        this.sha256 = sha256;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public Optional<byte[]> getSha256() {
        return Optional.ofNullable(this.sha256);
    }

    public void setSha256(Optional<byte[]> sha256) {
        this.sha256 = sha256.orElse(null);
    }

    public String toString() {
        return String.format("Fyle[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        FyleGenerated casted = (FyleGenerated)this.getClazz().cast(obj);
        return Objects.equals(this.filePath, casted.filePath) && Arrays.equals(this.sha256, casted.sha256);
    }

    static {
        ArrayList<String> fields = new ArrayList<String>(AbstractTableGenerated.ALL_FIELDS);
        fields.add(FILE_PATH_NAME);
        fields.add(SHA256_NAME);
        ALL_FIELDS = List.copyOf(fields);
        ArrayList refs = new ArrayList();
        refs.add(new TableReference(InboundAttachment.class, InboundAttachment.FK_FYLE, x -> Optional.of(x.getFyleId())));
        refs.add(new TableReference(OwnedAttachment.class, OwnedAttachment.FK_FYLE, x -> Optional.of(x.getFyleId())));
        refs.add(new TableReference(OutboundAttachment.class, OutboundAttachment.FK_FYLE, x -> Optional.of(x.getFyleId())));
        references = List.copyOf(refs);
    }
}

