/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables.gen;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.DiscussionCustomization;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Invitation;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.PreContact;
import io.olvid.windows.messenger.database.tables.PreGroup;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.TableReference;
import io.olvid.windows.messenger.database.tables.attachment.InboundAttachment;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.attachment.OwnedAttachment;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.InboundMessageSequenceInterval;
import io.olvid.windows.messenger.database.tables.message.MessageRef;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessageSequenceInterval;
import io.olvid.windows.messenger.database.tables.message.PendingMessage;
import io.olvid.windows.messenger.database.tables.message.SystemMessage;
import io.olvid.windows.messenger.database.tables.remoterequest.RemoteDeleteRequest;
import io.olvid.windows.messenger.database.tables.remoterequest.RemoteEditRequest;
import io.olvid.windows.messenger.database.tables.remoterequest.RemoteReactionRequest;
import io.olvid.windows.messenger.fx.misc.IComparable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public abstract class DiscussionGenerated<T extends DiscussionGenerated<T>>
extends AbstractTableGenerated<T>
implements Table {
    public static final String TABLE_NAME = "discussion_table";
    private static final String BYTES_DISCUSSION_IDENTIFIER_NAME = "bytes_discussion_identifier";
    public static final Column.ObjectColumn<Discussion, byte[]> BYTES_DISCUSSION_IDENTIFIER = new Column.ObjectColumn("bytes_discussion_identifier", false);
    private static final String LOCKED_TITLE_NAME = "locked_title";
    public static final Column.ObjectColumn<Discussion, String> LOCKED_TITLE = new Column.ObjectColumn("locked_title", true);
    private static final String FK_OWNED_IDENTITY_NAME = "fk_owned_identity";
    public static final Column.ForeignColumn<Discussion, OwnedIdentity> FK_OWNED_IDENTITY = new Column.ForeignColumn("fk_owned_identity", false);
    private static final String STATUS_NAME = "status";
    public static final Column.ObjectColumn<Discussion, Status> STATUS = new Column.ObjectColumn("status", false);
    private static final String SENDER_THREAD_IDENTIFIER_NAME = "sender_thread_identifier";
    public static final Column.ObjectColumn<Discussion, UUID> SENDER_THREAD_IDENTIFIER = new Column.ObjectColumn("sender_thread_identifier", false);
    private static final String LAST_OUTBOUND_MESSAGE_SEQUENCE_NUMBER_NAME = "last_outbound_message_sequence_number";
    public static final Column.longColumn<Discussion> LAST_OUTBOUND_MESSAGE_SEQUENCE_NUMBER = new Column.longColumn("last_outbound_message_sequence_number");
    private static final String FK_LAST_USER_MESSAGE_REF_NAME = "fk_last_user_message_ref";
    public static final Column.ForeignColumn<Discussion, MessageRef> FK_LAST_USER_MESSAGE_REF = new Column.ForeignColumn("fk_last_user_message_ref", true);
    private static final String FK_LAST_SYSTEM_MESSAGE_NAME = "fk_last_system_message";
    public static final Column.ForeignColumn<Discussion, SystemMessage> FK_LAST_SYSTEM_MESSAGE = new Column.ForeignColumn("fk_last_system_message", true);
    private static final String SORT_TIMESTAMP_NAME = "sort_timestamp";
    public static final Column.longColumn<Discussion> SORT_TIMESTAMP = new Column.longColumn("sort_timestamp");
    private static final String FK_CONTACT_NAME = "fk_contact";
    public static final Column.ForeignColumn<Discussion, Contact> FK_CONTACT = new Column.ForeignColumn("fk_contact", true);
    private static final String FK_PRE_CONTACT_NAME = "fk_pre_contact";
    public static final Column.ForeignColumn<Discussion, PreContact> FK_PRE_CONTACT = new Column.ForeignColumn("fk_pre_contact", true);
    private static final String FK_GROUP_NAME = "fk_group";
    public static final Column.ForeignColumn<Discussion, Group> FK_GROUP = new Column.ForeignColumn("fk_group", true);
    private static final String FK_PRE_GROUP_NAME = "fk_pre_group";
    public static final Column.ForeignColumn<Discussion, PreGroup> FK_PRE_GROUP = new Column.ForeignColumn("fk_pre_group", true);
    private static final String UNREAD_NAME = "unread";
    public static final Column.booleanColumn<Discussion> UNREAD = new Column.booleanColumn("unread");
    public static final List<String> ALL_FIELDS;
    @DatabaseField(columnName="bytes_discussion_identifier", canBeNull=false, dataType=DataType.BYTE_ARRAY)
    protected byte[] bytesDiscussionIdentifier;
    @DatabaseField(columnName="locked_title", dataType=DataType.STRING)
    protected String lockedTitle;
    @DatabaseField(columnName="fk_owned_identity", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_owned_identity NOT NULL REFERENCES owned_identity_table(gen_id) ON DELETE CASCADE")
    protected OwnedIdentity fkOwnedIdentity;
    @DatabaseField(columnName="status", canBeNull=false, dataType=DataType.ENUM_NAME)
    protected Status status;
    @DatabaseField(columnName="sender_thread_identifier", uniqueCombo=true, canBeNull=false, dataType=DataType.UUID)
    protected UUID senderThreadIdentifier;
    @DatabaseField(columnName="last_outbound_message_sequence_number", dataType=DataType.LONG)
    protected long lastOutboundMessageSequenceNumber;
    @DatabaseField(columnName="fk_last_user_message_ref", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_last_user_message_ref REFERENCES message_ref_table(gen_id) ON DELETE SET NULL")
    protected MessageRef fkLastUserMessageRef;
    @DatabaseField(columnName="fk_last_system_message", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_last_system_message REFERENCES system_message_table(gen_id) ON DELETE SET NULL")
    protected SystemMessage fkLastSystemMessage;
    @DatabaseField(columnName="sort_timestamp", dataType=DataType.LONG)
    protected long sortTimestamp;
    @DatabaseField(columnName="fk_contact", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_contact UNIQUE REFERENCES contact_table(gen_id) ON DELETE SET NULL")
    protected Contact fkContact;
    @DatabaseField(columnName="fk_pre_contact", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_pre_contact UNIQUE REFERENCES pre_contact_table(gen_id) ON DELETE SET NULL")
    protected PreContact fkPreContact;
    @DatabaseField(columnName="fk_group", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_group UNIQUE REFERENCES group_table(gen_id) ON DELETE SET NULL")
    protected Group fkGroup;
    @DatabaseField(columnName="fk_pre_group", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_pre_group UNIQUE REFERENCES pre_group_table(gen_id) ON DELETE SET NULL")
    protected PreGroup fkPreGroup;
    @DatabaseField(columnName="unread", dataType=DataType.BOOLEAN)
    protected boolean unread;
    public static final List<TableReference<?, Discussion>> references;

    public DiscussionGenerated() {
    }

    public DiscussionGenerated(long genId) {
        super(genId);
    }

    public DiscussionGenerated(long genId, byte[] bytesDiscussionIdentifier, String lockedTitle, OwnedIdentity ownedIdentity, Status status, UUID senderThreadIdentifier, long lastOutboundMessageSequenceNumber, MessageRef lastUserMessageRef, SystemMessage lastSystemMessage, long sortTimestamp, Contact contact, PreContact preContact, Group group, PreGroup preGroup, boolean unread) {
        super(genId);
        this.bytesDiscussionIdentifier = bytesDiscussionIdentifier;
        this.lockedTitle = lockedTitle;
        this.fkOwnedIdentity = ownedIdentity;
        this.status = status;
        this.senderThreadIdentifier = senderThreadIdentifier;
        this.lastOutboundMessageSequenceNumber = lastOutboundMessageSequenceNumber;
        this.fkLastUserMessageRef = lastUserMessageRef;
        this.fkLastSystemMessage = lastSystemMessage;
        this.sortTimestamp = sortTimestamp;
        this.fkContact = contact;
        this.fkPreContact = preContact;
        this.fkGroup = group;
        this.fkPreGroup = preGroup;
        this.unread = unread;
    }

    public byte[] getBytesDiscussionIdentifier() {
        return this.bytesDiscussionIdentifier;
    }

    public Optional<String> getLockedTitle() {
        return Optional.ofNullable(this.lockedTitle);
    }

    public void setLockedTitle(Optional<String> lockedTitle) {
        this.lockedTitle = lockedTitle.orElse(null);
    }

    public Id<OwnedIdentity> getOwnedIdentityId() {
        return this.fkOwnedIdentity.getItemId();
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public UUID getSenderThreadIdentifier() {
        return this.senderThreadIdentifier;
    }

    public void setSenderThreadIdentifier(UUID senderThreadIdentifier) {
        this.senderThreadIdentifier = senderThreadIdentifier;
    }

    public long getLastOutboundMessageSequenceNumber() {
        return this.lastOutboundMessageSequenceNumber;
    }

    public void setLastOutboundMessageSequenceNumber(long lastOutboundMessageSequenceNumber) {
        this.lastOutboundMessageSequenceNumber = lastOutboundMessageSequenceNumber;
    }

    public Optional<Id<MessageRef>> getLastUserMessageRefId() {
        return Optional.ofNullable(this.fkLastUserMessageRef).map(AbstractTableGenerated::getItemId);
    }

    public Optional<Id<SystemMessage>> getLastSystemMessageId() {
        return Optional.ofNullable(this.fkLastSystemMessage).map(AbstractTableGenerated::getItemId);
    }

    public long getSortTimestamp() {
        return this.sortTimestamp;
    }

    public void setSortTimestamp(long sortTimestamp) {
        this.sortTimestamp = sortTimestamp;
    }

    public Optional<Id<Contact>> getContactId() {
        return Optional.ofNullable(this.fkContact).map(AbstractTableGenerated::getItemId);
    }

    public void setContact(Optional<Contact> fkContact) {
        this.fkContact = fkContact.orElse(null);
    }

    public Optional<Id<PreContact>> getPreContactId() {
        return Optional.ofNullable(this.fkPreContact).map(AbstractTableGenerated::getItemId);
    }

    public void setPreContact(Optional<PreContact> fkPreContact) {
        this.fkPreContact = fkPreContact.orElse(null);
    }

    public Optional<Id<Group>> getGroupId() {
        return Optional.ofNullable(this.fkGroup).map(AbstractTableGenerated::getItemId);
    }

    public void setGroup(Optional<Group> fkGroup) {
        this.fkGroup = fkGroup.orElse(null);
    }

    public Optional<Id<PreGroup>> getPreGroupId() {
        return Optional.ofNullable(this.fkPreGroup).map(AbstractTableGenerated::getItemId);
    }

    public void setPreGroup(Optional<PreGroup> fkPreGroup) {
        this.fkPreGroup = fkPreGroup.orElse(null);
    }

    public boolean isUnread() {
        return this.unread;
    }

    public String toString() {
        return String.format("Discussion[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        DiscussionGenerated casted = (DiscussionGenerated)this.getClazz().cast(obj);
        return Arrays.equals(this.bytesDiscussionIdentifier, casted.bytesDiscussionIdentifier) && Objects.equals(this.lockedTitle, casted.lockedTitle) && Objects.equals(this.fkOwnedIdentity, casted.fkOwnedIdentity) && this.status == casted.status && Objects.equals(this.senderThreadIdentifier, casted.senderThreadIdentifier) && this.lastOutboundMessageSequenceNumber == casted.lastOutboundMessageSequenceNumber && Objects.equals(this.fkLastUserMessageRef, casted.fkLastUserMessageRef) && Objects.equals(this.fkLastSystemMessage, casted.fkLastSystemMessage) && this.sortTimestamp == casted.sortTimestamp && Objects.equals(this.fkContact, casted.fkContact) && Objects.equals(this.fkPreContact, casted.fkPreContact) && Objects.equals(this.fkGroup, casted.fkGroup) && Objects.equals(this.fkPreGroup, casted.fkPreGroup) && this.unread == casted.unread;
    }

    static {
        ArrayList<String> fields = new ArrayList<String>(AbstractTableGenerated.ALL_FIELDS);
        fields.add(BYTES_DISCUSSION_IDENTIFIER_NAME);
        fields.add(LOCKED_TITLE_NAME);
        fields.add(FK_OWNED_IDENTITY_NAME);
        fields.add(STATUS_NAME);
        fields.add(SENDER_THREAD_IDENTIFIER_NAME);
        fields.add(LAST_OUTBOUND_MESSAGE_SEQUENCE_NUMBER_NAME);
        fields.add(FK_LAST_USER_MESSAGE_REF_NAME);
        fields.add(FK_LAST_SYSTEM_MESSAGE_NAME);
        fields.add(SORT_TIMESTAMP_NAME);
        fields.add(FK_CONTACT_NAME);
        fields.add(FK_PRE_CONTACT_NAME);
        fields.add(FK_GROUP_NAME);
        fields.add(FK_PRE_GROUP_NAME);
        fields.add(UNREAD_NAME);
        ALL_FIELDS = List.copyOf(fields);
        ArrayList refs = new ArrayList();
        refs.add(new TableReference(InboundAttachment.class, InboundAttachment.FK_DISCUSSION, x -> Optional.of(x.getDiscussionId())));
        refs.add(new TableReference(OwnedAttachment.class, OwnedAttachment.FK_DISCUSSION, x -> Optional.of(x.getDiscussionId())));
        refs.add(new TableReference(OutboundAttachment.class, OutboundAttachment.FK_DISCUSSION, x -> Optional.of(x.getDiscussionId())));
        refs.add(new TableReference(InboundMessage.class, InboundMessage.FK_DISCUSSION, x -> Optional.of(x.getDiscussionId())));
        refs.add(new TableReference(InboundMessageSequenceInterval.class, InboundMessageSequenceInterval.FK_DISCUSSION, x -> Optional.of(x.getDiscussionId())));
        refs.add(new TableReference(OwnedMessageSequenceInterval.class, OwnedMessageSequenceInterval.FK_DISCUSSION, x -> Optional.of(x.getDiscussionId())));
        refs.add(new TableReference(OwnedMessage.class, OwnedMessage.FK_DISCUSSION, x -> Optional.of(x.getDiscussionId())));
        refs.add(new TableReference(OutboundMessage.class, OutboundMessage.FK_DISCUSSION, x -> Optional.of(x.getDiscussionId())));
        refs.add(new TableReference(SystemMessage.class, SystemMessage.FK_DISCUSSION, x -> Optional.of(x.getDiscussionId())));
        refs.add(new TableReference(MessageRef.class, MessageRef.FK_DISCUSSION, x -> Optional.of(x.getDiscussionId())));
        refs.add(new TableReference(PendingMessage.class, PendingMessage.FK_DISCUSSION, x -> Optional.of(x.getDiscussionId())));
        refs.add(new TableReference(RemoteDeleteRequest.class, RemoteDeleteRequest.FK_DISCUSSION, x -> Optional.of(x.getDiscussionId())));
        refs.add(new TableReference(RemoteEditRequest.class, RemoteEditRequest.FK_DISCUSSION, x -> Optional.of(x.getDiscussionId())));
        refs.add(new TableReference(RemoteReactionRequest.class, RemoteReactionRequest.FK_DISCUSSION, x -> Optional.of(x.getDiscussionId())));
        refs.add(new TableReference(DiscussionCustomization.class, DiscussionCustomization.FK_DISCUSSION, x -> Optional.of(x.getDiscussionId())));
        refs.add(new TableReference(Invitation.class, Invitation.FK_DISCUSSION, x -> Optional.of(x.getDiscussion()).map(AbstractTableGenerated::getItemId)));
        references = List.copyOf(refs);
    }

    public static enum Status implements IComparable<Status>
    {
        PRE_DISCUSSION,
        NORMAL,
        HIDDEN,
        LOCKED;

    }
}

