/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables;

import com.j256.ormlite.table.DatabaseTable;
import io.olvid.engine.engine.types.EngineAPI;
import io.olvid.engine.engine.types.identities.ObvIdentity;
import io.olvid.windows.messenger.database.tables.Capabilities;
import io.olvid.windows.messenger.database.tables.IdentityDetails;
import io.olvid.windows.messenger.database.tables.gen.OwnedIdentityGenerated;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;

@DatabaseTable(tableName="owned_identity_table")
public class OwnedIdentity
extends OwnedIdentityGenerated<OwnedIdentity> {
    public static OwnedIdentityGenerated.UnpublishedDetails unpublishedDetailsFromName(String name) {
        Optional<OwnedIdentityGenerated.UnpublishedDetails> unpublishedDetailsOpt = Arrays.stream(OwnedIdentityGenerated.UnpublishedDetails.values()).filter(detail -> detail.name().equals(name)).findFirst();
        return unpublishedDetailsOpt.orElse(OwnedIdentityGenerated.UnpublishedDetails.NOTHING_NEW);
    }

    public static OwnedIdentityGenerated.ApiKeyStatus of(EngineAPI.ApiKeyStatus status) {
        switch (status) {
            case UNKNOWN: {
                return OwnedIdentityGenerated.ApiKeyStatus.UNKNOWN;
            }
            case VALID: {
                return OwnedIdentityGenerated.ApiKeyStatus.VALID;
            }
            case LICENSES_EXHAUSTED: {
                return OwnedIdentityGenerated.ApiKeyStatus.LICENSES_EXHAUSTED;
            }
            case EXPIRED: {
                return OwnedIdentityGenerated.ApiKeyStatus.EXPIRED;
            }
            case OPEN_BETA_KEY: {
                return OwnedIdentityGenerated.ApiKeyStatus.OPEN_BETA_KEY;
            }
            case FREE_TRIAL_KEY: {
                return OwnedIdentityGenerated.ApiKeyStatus.FREE_TRIAL_KEY;
            }
            case AWAITING_PAYMENT_GRACE_PERIOD: {
                return OwnedIdentityGenerated.ApiKeyStatus.AWAITING_PAYMENT_GRACE_PERIOD;
            }
            case AWAITING_PAYMENT_ON_HOLD: {
                return OwnedIdentityGenerated.ApiKeyStatus.AWAITING_PAYMENT_ON_HOLD;
            }
            case FREE_TRIAL_KEY_EXPIRED: {
                return OwnedIdentityGenerated.ApiKeyStatus.FREE_TRIAL_KEY_EXPIRED;
            }
        }
        AppLogger.e("Found an EngineAPI.ApiKeyStatus that cannot be converted into ApiKeyStatus.");
        return OwnedIdentityGenerated.ApiKeyStatus.UNKNOWN;
    }

    public static OwnedIdentityGenerated.ApiKeyStatus apiKeyStatusFromId(String id) {
        for (OwnedIdentityGenerated.ApiKeyStatus status : OwnedIdentityGenerated.ApiKeyStatus.values()) {
            if (!status.toString().equals(id)) continue;
            return status;
        }
        AppLogger.e(String.format("Found an unknown ApiKeyStatus: %s", id));
        return OwnedIdentityGenerated.ApiKeyStatus.UNKNOWN;
    }

    public OwnedIdentity() {
    }

    public OwnedIdentity(long genId) {
        super(genId);
    }

    public OwnedIdentity(long genId, byte[] bytesOwnedIdentity, IdentityDetails identityDetails, String nickname, OwnedIdentityGenerated.ApiKeyStatus apiKeyStatus, OwnedIdentityGenerated.UnpublishedDetails unpublishedDetails, long apiKeyPermissions, Long apiKeyExpirationTimestamp, boolean isKeycloakManaged, boolean active, Capabilities capabilities) {
        super(genId, bytesOwnedIdentity, nickname, identityDetails, apiKeyStatus, unpublishedDetails, apiKeyPermissions, apiKeyExpirationTimestamp, isKeycloakManaged, active, capabilities);
    }

    public OwnedIdentity(ObvIdentity obvOwnedIdentity, OwnedIdentityGenerated.ApiKeyStatus apiKeyStatus, IdentityDetails identityDetails, Capabilities capabilities) {
        this(0L, obvOwnedIdentity.getBytesIdentity(), identityDetails, null, apiKeyStatus, OwnedIdentityGenerated.UnpublishedDetails.NOTHING_NEW, 0L, null, obvOwnedIdentity.isKeycloakManaged(), obvOwnedIdentity.isActive(), capabilities);
    }

    @Override
    protected Class<OwnedIdentity> getClazz() {
        return OwnedIdentity.class;
    }

    public EnumSet<ApiKeyPermission> getApiKeyPermissionsEnum() {
        return ApiKeyPermission.of(this.apiKeyPermissions);
    }

    public void setApiKeyPermissions(EnumSet<ApiKeyPermission> permissions) {
        this.apiKeyPermissions = ApiKeyPermission.of(permissions);
    }

    public static enum ApiKeyPermission {
        CALL(0),
        WEB_CLIENT(1),
        MULTI_DEVICE(2);

        final int id;
        public static final ApiKeyPermission[] values;

        private ApiKeyPermission(int id) {
            this.id = id;
        }

        public static Optional<ApiKeyPermission> of(EngineAPI.ApiKeyPermission permission) {
            switch (permission) {
                case CALL: {
                    return Optional.of(CALL);
                }
                case WEB_CLIENT: {
                    return Optional.of(WEB_CLIENT);
                }
                case MULTI_DEVICE: {
                    return Optional.of(MULTI_DEVICE);
                }
            }
            AppLogger.e(String.format("ApiKeyPermission is not complete: missing to deal with %s", permission));
            return Optional.empty();
        }

        public static EnumSet<ApiKeyPermission> of(List<EngineAPI.ApiKeyPermission> enginePermissions) {
            EnumSet<ApiKeyPermission> result = EnumSet.noneOf(ApiKeyPermission.class);
            for (EngineAPI.ApiKeyPermission enginePermission : enginePermissions) {
                Optional<ApiKeyPermission> permissionOpt = ApiKeyPermission.of(enginePermission);
                permissionOpt.ifPresent(result::add);
            }
            return result;
        }

        public static EnumSet<ApiKeyPermission> of(long value) {
            EnumSet<ApiKeyPermission> result = EnumSet.noneOf(ApiKeyPermission.class);
            for (ApiKeyPermission permission : values) {
                if ((value & 1L << permission.id) == 0L) continue;
                result.add(permission);
            }
            return result;
        }

        public static long of(EnumSet<ApiKeyPermission> permissions) {
            long result = 0L;
            for (ApiKeyPermission permission : values) {
                if (!permissions.contains((Object)permission)) continue;
                result |= 1L << permission.id;
            }
            return result;
        }

        static {
            values = ApiKeyPermission.values();
        }
    }
}

