/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables;

import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.datatypes.json.JsonLocation;
import io.olvid.windows.messenger.database.tables.gen.LocationGenerated;
import java.util.Arrays;
import java.util.Optional;

@DatabaseTable(tableName="location_table")
public class Location
extends LocationGenerated<Location> {
    public static Optional<LocationGenerated.Type> typeFromId(int id) {
        return Arrays.stream(LocationGenerated.Type.values()).filter(t -> Location.idFromType(t) == id).findFirst();
    }

    public static int idFromType(LocationGenerated.Type type) {
        switch (type) {
            case SEND: {
                return 1;
            }
            case SHARE: {
                return 2;
            }
            case SHARE_FINISHED: {
                return 3;
            }
        }
        throw new IllegalStateException();
    }

    public Location() {
    }

    public Location(long genId) {
        super(genId);
    }

    public Location(LocationGenerated.Type type, long timestamp, Long count, Long sharingInterval, Long sharingExpiration, double latitude, double longitude, Double altitude, Float precision, String address) {
        super(0L, type, timestamp, count, sharingInterval, sharingExpiration, latitude, longitude, altitude, precision, address);
    }

    @Override
    protected Class<Location> getClazz() {
        return Location.class;
    }

    public static Optional<Location> of(JsonLocation jsonLocation) {
        Optional<LocationGenerated.Type> typeOpt = Location.typeFromId(jsonLocation.getType());
        if (typeOpt.isEmpty()) {
            return Optional.empty();
        }
        Location location = new Location(typeOpt.get(), jsonLocation.getTimestamp(), jsonLocation.getCount(), jsonLocation.getSharingInterval(), jsonLocation.getSharingExpiration(), jsonLocation.getLatitude(), jsonLocation.getLongitude(), jsonLocation.getAltitude(), jsonLocation.getPrecision(), jsonLocation.getAddress());
        return Optional.of(location);
    }

    public JsonLocation toJson() {
        JsonLocation jsonLocation = new JsonLocation();
        jsonLocation.setType(Location.idFromType(this.type));
        jsonLocation.setTimestamp(this.timestamp);
        jsonLocation.setCount(this.count);
        jsonLocation.setSharingInterval(this.sharingInterval);
        jsonLocation.setSharingExpiration(this.sharingExpiration);
        jsonLocation.setLatitude(this.latitude);
        jsonLocation.setLongitude(this.longitude);
        jsonLocation.setAltitude(this.altitude);
        jsonLocation.setPrecision(this.precision);
        jsonLocation.setAddress(this.address);
        return jsonLocation;
    }
}

