/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables;

import com.j256.ormlite.table.DatabaseTable;
import io.olvid.engine.engine.types.JsonIdentityDetails;
import io.olvid.windows.messenger.database.tables.gen.IdentityDetailsGenerated;
import io.olvid.windows.messenger.fx.misc.OptionalUtils;
import java.text.Collator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@DatabaseTable(tableName="identity_details_table")
public class IdentityDetails
extends IdentityDetailsGenerated<IdentityDetails> {
    public IdentityDetails() {
    }

    public IdentityDetails(long genId) {
        super(genId);
    }

    @Override
    protected Class<IdentityDetails> getClazz() {
        return IdentityDetails.class;
    }

    public IdentityDetails(JsonIdentityDetails details) {
        super(0L, details.getFirstName(), details.getLastName(), details.getCompany(), details.getPosition(), null);
    }

    public boolean equalsTo(JsonIdentityDetails details) {
        return Objects.equals(this.firstName, details.getFirstName()) && Objects.equals(this.lastName, details.getLastName()) && Objects.equals(this.company, details.getCompany()) && Objects.equals(this.position, details.getPosition());
    }

    public byte[] computeSortDisplayName(Optional<String> customName) {
        Collator collator = Collator.getInstance();
        if (customName.isEmpty()) {
            Optional<String> concat = OptionalUtils.join(" ", List.of(this.getFirstName(), this.getLastName()));
            if (concat.isEmpty()) {
                return new byte[0];
            }
            return collator.getCollationKey(concat.get()).toByteArray();
        }
        return collator.getCollationKey(customName.get()).toByteArray();
    }
}

