/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables;

import com.j256.ormlite.table.DatabaseTable;
import io.olvid.engine.datatypes.containers.GroupV2;
import io.olvid.windows.messenger.database.tables.ContactGroupJoin;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.PendingGroupMember;
import io.olvid.windows.messenger.database.tables.PreGroup;
import io.olvid.windows.messenger.database.tables.gen.GroupMemberPermissionsGenerated;
import io.olvid.windows.messenger.misc.Either;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

@DatabaseTable(tableName="group_member_permissions_table")
public class GroupMemberPermissions
extends GroupMemberPermissionsGenerated<GroupMemberPermissions> {
    public GroupMemberPermissions() {
    }

    public GroupMemberPermissions(OwnedIdentity fkaOwnedIdentity, Group fkGroup, PreGroup fkPreGroup, ContactGroupJoin fkaContactGroupJoin, PendingGroupMember fkaPendingGroupMember, Set<String> permissions) {
        super(0L, fkaOwnedIdentity, fkGroup, fkPreGroup, fkaContactGroupJoin, fkaPendingGroupMember, permissions.contains(GroupV2.Permission.GROUP_ADMIN.getString()), permissions.contains(GroupV2.Permission.REMOTE_DELETE_ANYTHING.getString()), permissions.contains(GroupV2.Permission.EDIT_OR_REMOTE_DELETE_OWN_MESSAGES.getString()), permissions.contains(GroupV2.Permission.CHANGE_SETTINGS.getString()), permissions.contains(GroupV2.Permission.SEND_MESSAGE.getString()));
    }

    public GroupMemberPermissions(long genId, OwnedIdentity ownedIdentity, Group group, PreGroup preGroup, ContactGroupJoin contactGroupJoin, PendingGroupMember pendingGroupMember, boolean admin, boolean remoteDeleteAnything, boolean editOrRemoteDeleteOwnMessages, boolean changeSettings, boolean sendMessage) {
        super(genId, ownedIdentity, group, preGroup, contactGroupJoin, pendingGroupMember, admin, remoteDeleteAnything, editOrRemoteDeleteOwnMessages, changeSettings, sendMessage);
    }

    @Override
    protected Class<GroupMemberPermissions> getClazz() {
        return GroupMemberPermissions.class;
    }

    public boolean updatePermissionsIfNeeded(HashSet<GroupV2.Permission> newPermissions) {
        if (!this.getPermissions().equals(newPermissions)) {
            this.updatePermissions(newPermissions);
            return true;
        }
        return false;
    }

    public void updatePermissions(Set<GroupV2.Permission> newPermissions) {
        this.admin = newPermissions.contains(GroupV2.Permission.GROUP_ADMIN);
        this.remoteDeleteAnything = newPermissions.contains(GroupV2.Permission.REMOTE_DELETE_ANYTHING);
        this.editOrRemoteDeleteOwnMessages = newPermissions.contains(GroupV2.Permission.EDIT_OR_REMOTE_DELETE_OWN_MESSAGES);
        this.changeSettings = newPermissions.contains(GroupV2.Permission.CHANGE_SETTINGS);
        this.sendMessage = newPermissions.contains(GroupV2.Permission.SEND_MESSAGE);
    }

    public Set<GroupV2.Permission> getPermissions() {
        EnumSet<GroupV2.Permission> permissions = EnumSet.noneOf(GroupV2.Permission.class);
        if (this.admin) {
            permissions.add(GroupV2.Permission.GROUP_ADMIN);
        }
        if (this.remoteDeleteAnything) {
            permissions.add(GroupV2.Permission.REMOTE_DELETE_ANYTHING);
        }
        if (this.editOrRemoteDeleteOwnMessages) {
            permissions.add(GroupV2.Permission.EDIT_OR_REMOTE_DELETE_OWN_MESSAGES);
        }
        if (this.changeSettings) {
            permissions.add(GroupV2.Permission.CHANGE_SETTINGS);
        }
        if (this.sendMessage) {
            permissions.add(GroupV2.Permission.SEND_MESSAGE);
        }
        return permissions;
    }

    public void setGroupOrPreGroup(Either<Group, PreGroup> either) {
        if (either.isLeft()) {
            this.fkGroup = either.getLeft();
            this.fkPreGroup = null;
        } else {
            this.fkGroup = null;
            this.fkPreGroup = either.getRight();
        }
    }
}

