/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables;

import com.j256.ormlite.table.DatabaseTable;
import io.olvid.engine.engine.types.JsonGroupDetails;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.gen.GroupGenerated;
import java.util.Optional;

@DatabaseTable(tableName="group_table")
public class Group
extends GroupGenerated<Group> {
    public Group() {
    }

    public Group(long genId) {
        super(genId);
    }

    public Group(long genId, OwnedIdentity ownedIdentity, byte[] bytesGroupIdentifier, GroupGenerated.Version version, boolean keycloakManaged, GroupGenerated.PublishedDetails newPublishedDetails, String name, String description, String photoUrl, String customName, String groupMembersNames, String customPhotoUrl, GroupGenerated.Update updateInProgress, String personalNote) {
        super(genId, ownedIdentity, bytesGroupIdentifier, version, keycloakManaged, newPublishedDetails, name, description, photoUrl, customName, groupMembersNames, customPhotoUrl, updateInProgress, personalNote);
    }

    @Override
    protected Class<Group> getClazz() {
        return Group.class;
    }

    public static Group makeGroupV1(OwnedIdentity fkaOwnedIdentity, byte[] groupIdentifier, String name, String description, GroupGenerated.PublishedDetails newPublishedDetails) {
        return new Group(0L, fkaOwnedIdentity, groupIdentifier, GroupGenerated.Version.VERSION_1, false, newPublishedDetails, name, description, null, null, null, null, GroupGenerated.Update.NONE, null);
    }

    public static Group makeGroupV2(OwnedIdentity associatedOwnedIdentity, byte[] bytesGroupIdentifier, String groupName, String groupDescription, boolean keycloakManaged, GroupGenerated.PublishedDetails newPublishedDetails, String photoUrl) {
        return new Group(0L, associatedOwnedIdentity, bytesGroupIdentifier, GroupGenerated.Version.VERSION_2, keycloakManaged, newPublishedDetails, groupName, groupDescription, photoUrl, null, null, null, GroupGenerated.Update.NONE, null);
    }

    public static Group createGroupV1ForMultipleDetails(byte[] groupIdentifier, boolean isOwnedIdentityAdmin, OwnedIdentity fkaOwnedIdentity, JsonGroupDetails jsonGroupDetails, String photoUrl, boolean hasMultipleDetails) {
        GroupGenerated.PublishedDetails newPublishedDetails = hasMultipleDetails ? (isOwnedIdentityAdmin ? GroupGenerated.PublishedDetails.UNPUBLISHED_NEW : GroupGenerated.PublishedDetails.NEW_UNSEEN) : GroupGenerated.PublishedDetails.NOTHING_NEW;
        return new Group(0L, fkaOwnedIdentity, groupIdentifier, GroupGenerated.Version.VERSION_1, false, newPublishedDetails, jsonGroupDetails.getName(), jsonGroupDetails.getDescription(), photoUrl, null, null, null, GroupGenerated.Update.NONE, null);
    }

    public Optional<String> getCustomNameOrName() {
        return this.getCustomName().or(this::getName);
    }

    public Optional<String> getCustomPhotoUrlOrPhotoUrl() {
        return this.getCustomPhotoUrl().or(this::getPhotoUrl);
    }

    private Optional<String> getNonEmptyGroupMembersNames() {
        return this.getGroupMembersNames().filter(s -> !s.isEmpty());
    }

    public Optional<String> getDisplayName() {
        return this.getCustomName().or(this::getName).or(this::getNonEmptyGroupMembersNames);
    }

    public boolean isNameEmpty() {
        return this.getCustomNameOrName().isEmpty();
    }

    public boolean isV2() {
        return this.version == GroupGenerated.Version.VERSION_2;
    }

    @Override
    public String toString() {
        return super.toString() + " " + String.valueOf(this.getDisplayName());
    }
}

