/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables;

import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.tables.gen.FyleGenerated;
import io.olvid.windows.messenger.engine.helpers.files.FileApi;
import io.olvid.windows.messenger.logger.AppLogger;
import java.io.File;

@DatabaseTable(tableName="fyle_table")
public class Fyle
extends FyleGenerated<Fyle> {
    public Fyle() {
    }

    public Fyle(long genId) {
        super(genId);
    }

    public Fyle(String filePath, byte[] sha256) {
        super(0L, filePath, sha256);
    }

    public Fyle(String filePath) {
        this(filePath, null);
    }

    @Override
    protected Class<Fyle> getClazz() {
        return Fyle.class;
    }

    public static String buildRelativeFylePath(byte[] sha256) {
        return "fyles" + File.separator + AppLogger.toHexString(sha256);
    }

    public void moveToFyleDirectory(String oldRelativePath) throws Exception {
        String newRelativePath = Fyle.buildRelativeFylePath(this.sha256);
        FileApi._moveFile(newRelativePath, oldRelativePath);
        this.filePath = newRelativePath;
    }

    public boolean isComplete() {
        return this.sha256 != null;
    }

    @Override
    public String toString() {
        if (this.sha256 != null) {
            return String.format("(fyle (%s): path: %s | sha: %s)", this.getItemId(), this.filePath, AppLogger.toHexString(this.sha256).substring(0, 5));
        }
        return String.format("(fyle (%s): path: %s | sha: null)", this.getItemId(), this.filePath);
    }
}

