/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables;

import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.datatypes.json.JsonColor;
import io.olvid.windows.messenger.database.datatypes.json.JsonExpiration;
import io.olvid.windows.messenger.database.datatypes.json.JsonSharedSettings;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.gen.DiscussionCustomizationGenerated;
import io.olvid.windows.messenger.engine.EngineWrapper;
import java.io.File;

@DatabaseTable(tableName="discussion_customization_table")
public class DiscussionCustomization
extends DiscussionCustomizationGenerated<DiscussionCustomization> {
    public static final String DISCUSSION_BACKGROUNDS_DIRECTORY = "discussion_backgrounds";

    DiscussionCustomization() {
    }

    @Override
    protected Class<DiscussionCustomization> getClazz() {
        return DiscussionCustomization.class;
    }

    public static DiscussionCustomization createBlankDiscussionCustomization(Discussion discussion) {
        return new DiscussionCustomization(discussion);
    }

    public static DiscussionCustomization createDiscussionCustomizationFromDefaultValues(Discussion discussion) {
        DiscussionCustomization discussionCustomization = new DiscussionCustomization(discussion);
        discussionCustomization.resetDiscussionCustomizationToDefault();
        return discussionCustomization;
    }

    private DiscussionCustomization(Discussion discussion) {
        this.fkDiscussion = discussion;
        this.resetDiscussionCustomizationToDefault();
    }

    public void resetDiscussionCustomizationToDefault() {
        this.serializedColorJson = null;
        this.backgroundImageUrl = null;
        this.prefSendReadReceipt = null;
        this.prefMuteNotifications = false;
        this.prefMuteNotificationsTimestamp = null;
        this.prefAutoOpenLimitedVisibilityInboundMessages = null;
        this.prefRetainWipedOutboundMessages = null;
        this.prefDiscussionRetentionCount = null;
        this.prefDiscussionRetentionDuration = null;
        Object existenceDuration = null;
        Object visibilityDuration = null;
        boolean readOnce = false;
        this.settingExistenceDuration = existenceDuration;
        this.settingVisibilityDuration = visibilityDuration;
        this.settingReadOnce = readOnce;
        this.sharedSettingsVersion = 0;
    }

    public JsonSharedSettings getSharedSettingsJson() {
        JsonSharedSettings jsonSharedSettings = new JsonSharedSettings();
        jsonSharedSettings.setVersion(this.sharedSettingsVersion);
        jsonSharedSettings.setJsonExpiration(this.getExpirationJson());
        return jsonSharedSettings;
    }

    public JsonExpiration getExpirationJson() {
        if (!this.settingReadOnce && this.settingVisibilityDuration == null && this.settingExistenceDuration == null) {
            return null;
        }
        JsonExpiration expiration = new JsonExpiration();
        expiration.setReadOnce(this.settingReadOnce);
        expiration.setVisibilityDuration(this.settingVisibilityDuration);
        expiration.setExistenceDuration(this.settingExistenceDuration);
        return expiration;
    }

    public String buildBackgroundImagePath() {
        return DISCUSSION_BACKGROUNDS_DIRECTORY + File.separator + String.valueOf(this.getItemId()) + "-" + System.currentTimeMillis();
    }

    public boolean shouldMuteNotifications() {
        if (this.prefMuteNotificationsTimestamp == null || this.prefMuteNotificationsTimestamp > System.currentTimeMillis()) {
            return this.prefMuteNotifications;
        }
        return false;
    }

    public JsonColor getColorJson() {
        if (this.serializedColorJson == null) {
            return null;
        }
        try {
            return (JsonColor)EngineWrapper.getJsonObjectMapper().readValue(this.serializedColorJson, JsonColor.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setColorJson(JsonColor colorJson) throws Exception {
        this.serializedColorJson = colorJson == null ? null : EngineWrapper.getJsonObjectMapper().writeValueAsString((Object)colorJson);
    }

    @Override
    public String toString() {
        return String.format("(DiscussionCustomization (%s): %s)", this.getItemId(), this.fkDiscussion);
    }

    public boolean getSettingReadOnce() {
        return this.settingReadOnce;
    }

    @Override
    @Deprecated
    public boolean isPrefMuteNotifications() {
        return super.isPrefMuteNotifications();
    }
}

