/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.tables;

import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.PreContact;
import io.olvid.windows.messenger.database.tables.PreGroup;
import io.olvid.windows.messenger.database.tables.gen.DiscussionGenerated;
import io.olvid.windows.messenger.livedata.Diffable;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

@DatabaseTable(tableName="discussion_table")
public class Discussion
extends DiscussionGenerated<Discussion>
implements Diffable {
    private final AppLogger logger = new AppLogger(this.getClass());
    public static final String emptyGroupTitle = "";

    public Discussion() {
    }

    public Discussion(long genId) {
        super(genId);
    }

    private Discussion(byte[] bytesDiscussionIdentifier, OwnedIdentity ownedIdentity, DiscussionGenerated.Status discussionStatus, Optional<Contact> fkaContact, Optional<PreContact> fkaPreContact, Optional<Group> fkaGroup, Optional<PreGroup> fkaPreGroup) {
        super(0L, bytesDiscussionIdentifier, null, ownedIdentity, discussionStatus, UUID.randomUUID(), 0L, null, null, System.currentTimeMillis(), fkaContact.orElse(null), fkaPreContact.orElse(null), fkaGroup.orElse(null), fkaPreGroup.orElse(null), false);
        this.checkInvariants();
    }

    public Discussion(byte[] bytesDiscussionIdentifier, OwnedIdentity fkaOwnedIdentity, DiscussionGenerated.Status discussionStatus, PreContact fkaPreContact) {
        this(bytesDiscussionIdentifier, fkaOwnedIdentity, discussionStatus, Optional.empty(), Optional.of(fkaPreContact), Optional.empty(), Optional.empty());
    }

    public Discussion(byte[] bytesDiscussionIdentifier, OwnedIdentity fkaOwnedIdentity, DiscussionGenerated.Status discussionStatus, Contact contact) {
        this(bytesDiscussionIdentifier, fkaOwnedIdentity, discussionStatus, Optional.of(contact), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public Discussion(byte[] bytesDiscussionIdentifier, OwnedIdentity fkaOwnedIdentity, DiscussionGenerated.Status discussionStatus, Group group) {
        this(bytesDiscussionIdentifier, fkaOwnedIdentity, discussionStatus, Optional.empty(), Optional.empty(), Optional.of(group), Optional.empty());
    }

    public Discussion(byte[] bytesDiscussionIdentifier, OwnedIdentity fkaOwnedIdentity, DiscussionGenerated.Status discussionStatus, PreGroup preGroup) {
        this(bytesDiscussionIdentifier, fkaOwnedIdentity, discussionStatus, Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(preGroup));
    }

    @Override
    protected Class<Discussion> getClazz() {
        return Discussion.class;
    }

    private void checkInvariants() {
        AtomicInteger setFields = new AtomicInteger();
        this.getContactId().ifPresent(c -> setFields.addAndGet(1));
        this.getPreContactId().ifPresent(c -> setFields.addAndGet(1));
        this.getGroupId().ifPresent(c -> setFields.addAndGet(1));
        this.getPreGroupId().ifPresent(c -> setFields.addAndGet(1));
        this.getLockedTitle().ifPresent(c -> setFields.addAndGet(1));
        if (setFields.get() > 1) {
            this.logger.error("More than one fields is set in " + String.valueOf(this.getItemId()));
        }
    }

    @Override
    public void setLockedTitle(Optional<String> lockedTitle) {
        super.setLockedTitle(lockedTitle);
        this.checkInvariants();
    }

    @Override
    public void setContact(Optional<Contact> fkContact) {
        super.setContact(fkContact);
        this.checkInvariants();
    }

    @Override
    public void setPreContact(Optional<PreContact> fkPreContact) {
        super.setPreContact(fkPreContact);
        this.checkInvariants();
    }

    @Override
    public void setGroup(Optional<Group> fkGroup) {
        super.setGroup(fkGroup);
        this.checkInvariants();
    }

    @Override
    public void setPreGroup(Optional<PreGroup> fkPreGroup) {
        super.setPreGroup(fkPreGroup);
        this.checkInvariants();
    }

    public boolean isPreDiscussion() {
        return this.status == DiscussionGenerated.Status.PRE_DISCUSSION;
    }

    public boolean isLocked() {
        return this.status == DiscussionGenerated.Status.LOCKED;
    }

    public boolean isHidden() {
        return this.status == DiscussionGenerated.Status.HIDDEN;
    }

    public boolean canPostMessage() {
        return !this.isLocked() && !this.isPreDiscussion();
    }

    public boolean isContactDiscussion() {
        return this.getContactId().isPresent();
    }

    public boolean isGroupDiscussion() {
        return this.getGroupId().isPresent();
    }

    public Kind getKind() {
        if (this.getContactId().isPresent()) {
            return Kind.CONTACT;
        }
        if (this.getPreContactId().isPresent()) {
            return Kind.PRE_CONTACT;
        }
        if (this.getGroupId().isPresent()) {
            return Kind.GROUP;
        }
        if (this.getPreGroupId().isPresent()) {
            return Kind.PRE_GROUP;
        }
        return Kind.LOCKED;
    }

    @Override
    public String toString() {
        return String.format("Discussion[%s] %s %s%s%s%s%s", this.getItemId(), this.status, this.getContactId().map(Id::toString).orElse(emptyGroupTitle), this.getPreContactId().map(Id::toString).orElse(emptyGroupTitle), this.getGroupId().map(Id::toString).orElse(emptyGroupTitle), this.getPreGroupId().map(Id::toString).orElse(emptyGroupTitle), this.getLockedTitle().orElse(emptyGroupTitle));
    }

    public static enum Kind {
        CONTACT,
        PRE_CONTACT,
        GROUP,
        PRE_GROUP,
        LOCKED;

    }
}

