/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v8;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v8.ContactV8;
import io.olvid.windows.messenger.database.migrations.gen.v8.GroupV8;
import io.olvid.windows.messenger.database.migrations.gen.v8.OwnedIdentityV8;
import io.olvid.windows.messenger.database.migrations.gen.v8.PreContactV8;
import io.olvid.windows.messenger.database.migrations.gen.v8.PreGroupV8;
import io.olvid.windows.messenger.database.migrations.gen.v8.message.MessageRefV8;
import io.olvid.windows.messenger.database.migrations.gen.v8.message.SystemMessageV8;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.fx.misc.IComparable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@DatabaseTable(tableName="discussion_table")
public class DiscussionV8
extends AbstractTableGenerated<DiscussionV8>
implements Table {
    public static final String TABLE_NAME = "discussion_table";
    private static final String BYTES_DISCUSSION_IDENTIFIER_NAME = "bytes_discussion_identifier";
    public static final Column.ObjectColumn<DiscussionV8, byte[]> BYTES_DISCUSSION_IDENTIFIER = new Column.ObjectColumn("bytes_discussion_identifier", false);
    private static final String LOCKED_TITLE_NAME = "locked_title";
    public static final Column.ObjectColumn<DiscussionV8, String> LOCKED_TITLE = new Column.ObjectColumn("locked_title", true);
    private static final String FK_OWNED_IDENTITY_NAME = "fk_owned_identity";
    public static final Column.ForeignColumn<DiscussionV8, OwnedIdentityV8> FK_OWNED_IDENTITY = new Column.ForeignColumn("fk_owned_identity", false);
    private static final String STATUS_NAME = "status";
    public static final Column.ObjectColumn<DiscussionV8, Status> STATUS = new Column.ObjectColumn("status", false);
    private static final String SENDER_THREAD_IDENTIFIER_NAME = "sender_thread_identifier";
    public static final Column.ObjectColumn<DiscussionV8, UUID> SENDER_THREAD_IDENTIFIER = new Column.ObjectColumn("sender_thread_identifier", false);
    private static final String LAST_OUTBOUND_MESSAGE_SEQUENCE_NUMBER_NAME = "last_outbound_message_sequence_number";
    public static final Column.longColumn<DiscussionV8> LAST_OUTBOUND_MESSAGE_SEQUENCE_NUMBER = new Column.longColumn("last_outbound_message_sequence_number");
    private static final String FK_LAST_USER_MESSAGE_REF_NAME = "fk_last_user_message_ref";
    public static final Column.ForeignColumn<DiscussionV8, MessageRefV8> FK_LAST_USER_MESSAGE_REF = new Column.ForeignColumn("fk_last_user_message_ref", true);
    private static final String FK_LAST_SYSTEM_MESSAGE_NAME = "fk_last_system_message";
    public static final Column.ForeignColumn<DiscussionV8, SystemMessageV8> FK_LAST_SYSTEM_MESSAGE = new Column.ForeignColumn("fk_last_system_message", true);
    private static final String SORT_TIMESTAMP_NAME = "sort_timestamp";
    public static final Column.longColumn<DiscussionV8> SORT_TIMESTAMP = new Column.longColumn("sort_timestamp");
    private static final String FK_CONTACT_NAME = "fk_contact";
    public static final Column.ForeignColumn<DiscussionV8, ContactV8> FK_CONTACT = new Column.ForeignColumn("fk_contact", true);
    private static final String FK_PRE_CONTACT_NAME = "fk_pre_contact";
    public static final Column.ForeignColumn<DiscussionV8, PreContactV8> FK_PRE_CONTACT = new Column.ForeignColumn("fk_pre_contact", true);
    private static final String FK_GROUP_NAME = "fk_group";
    public static final Column.ForeignColumn<DiscussionV8, GroupV8> FK_GROUP = new Column.ForeignColumn("fk_group", true);
    private static final String FK_PRE_GROUP_NAME = "fk_pre_group";
    public static final Column.ForeignColumn<DiscussionV8, PreGroupV8> FK_PRE_GROUP = new Column.ForeignColumn("fk_pre_group", true);
    private static final String UNREAD_NAME = "unread";
    public static final Column.booleanColumn<DiscussionV8> UNREAD = new Column.booleanColumn("unread");
    @DatabaseField(columnName="bytes_discussion_identifier", canBeNull=false, dataType=DataType.BYTE_ARRAY)
    protected byte[] bytesDiscussionIdentifier;
    @DatabaseField(columnName="locked_title", dataType=DataType.STRING)
    protected String lockedTitle;
    @DatabaseField(columnName="fk_owned_identity", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_owned_identity NOT NULL REFERENCES owned_identity_table(gen_id) ON DELETE CASCADE")
    protected OwnedIdentityV8 fkOwnedIdentity;
    @DatabaseField(columnName="status", canBeNull=false, dataType=DataType.ENUM_NAME)
    protected Status status;
    @DatabaseField(columnName="sender_thread_identifier", uniqueCombo=true, canBeNull=false, dataType=DataType.UUID)
    protected UUID senderThreadIdentifier;
    @DatabaseField(columnName="last_outbound_message_sequence_number", dataType=DataType.LONG)
    protected long lastOutboundMessageSequenceNumber;
    @DatabaseField(columnName="fk_last_user_message_ref", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_last_user_message_ref REFERENCES message_ref_table(gen_id) ON DELETE SET NULL")
    protected MessageRefV8 fkLastUserMessageRef;
    @DatabaseField(columnName="fk_last_system_message", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_last_system_message REFERENCES system_message_table(gen_id) ON DELETE SET NULL")
    protected SystemMessageV8 fkLastSystemMessage;
    @DatabaseField(columnName="sort_timestamp", dataType=DataType.LONG)
    protected long sortTimestamp;
    @DatabaseField(columnName="fk_contact", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_contact UNIQUE REFERENCES contact_table(gen_id) ON DELETE SET NULL")
    protected ContactV8 fkContact;
    @DatabaseField(columnName="fk_pre_contact", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_pre_contact UNIQUE REFERENCES pre_contact_table(gen_id) ON DELETE SET NULL")
    protected PreContactV8 fkPreContact;
    @DatabaseField(columnName="fk_group", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_group UNIQUE REFERENCES group_table(gen_id) ON DELETE SET NULL")
    protected GroupV8 fkGroup;
    @DatabaseField(columnName="fk_pre_group", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_pre_group UNIQUE REFERENCES pre_group_table(gen_id) ON DELETE SET NULL")
    protected PreGroupV8 fkPreGroup;
    @DatabaseField(columnName="unread", dataType=DataType.BOOLEAN)
    protected boolean unread;

    public DiscussionV8() {
    }

    public DiscussionV8(long genId) {
        super(genId);
    }

    public DiscussionV8(long genId, byte[] bytesDiscussionIdentifier, String lockedTitle, OwnedIdentityV8 ownedIdentity, Status status, UUID senderThreadIdentifier, long lastOutboundMessageSequenceNumber, MessageRefV8 lastUserMessageRef, SystemMessageV8 lastSystemMessage, long sortTimestamp, ContactV8 contact, PreContactV8 preContact, GroupV8 group, PreGroupV8 preGroup, boolean unread) {
        super(genId);
        this.bytesDiscussionIdentifier = bytesDiscussionIdentifier;
        this.lockedTitle = lockedTitle;
        this.fkOwnedIdentity = ownedIdentity;
        this.status = status;
        this.senderThreadIdentifier = senderThreadIdentifier;
        this.lastOutboundMessageSequenceNumber = lastOutboundMessageSequenceNumber;
        this.fkLastUserMessageRef = lastUserMessageRef;
        this.fkLastSystemMessage = lastSystemMessage;
        this.sortTimestamp = sortTimestamp;
        this.fkContact = contact;
        this.fkPreContact = preContact;
        this.fkGroup = group;
        this.fkPreGroup = preGroup;
        this.unread = unread;
    }

    public byte[] getBytesDiscussionIdentifier() {
        return this.bytesDiscussionIdentifier;
    }

    public Optional<String> getLockedTitle() {
        return Optional.ofNullable(this.lockedTitle);
    }

    public void setLockedTitle(Optional<String> lockedTitle) {
        this.lockedTitle = lockedTitle.orElse(null);
    }

    public Id<OwnedIdentityV8> getOwnedIdentityId() {
        return this.fkOwnedIdentity.getItemId();
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public UUID getSenderThreadIdentifier() {
        return this.senderThreadIdentifier;
    }

    public void setSenderThreadIdentifier(UUID senderThreadIdentifier) {
        this.senderThreadIdentifier = senderThreadIdentifier;
    }

    public long getLastOutboundMessageSequenceNumber() {
        return this.lastOutboundMessageSequenceNumber;
    }

    public void setLastOutboundMessageSequenceNumber(long lastOutboundMessageSequenceNumber) {
        this.lastOutboundMessageSequenceNumber = lastOutboundMessageSequenceNumber;
    }

    public Optional<Id<MessageRefV8>> getLastUserMessageRefId() {
        return Optional.ofNullable(this.fkLastUserMessageRef).map(AbstractTableGenerated::getItemId);
    }

    public Optional<Id<SystemMessageV8>> getLastSystemMessageId() {
        return Optional.ofNullable(this.fkLastSystemMessage).map(AbstractTableGenerated::getItemId);
    }

    public long getSortTimestamp() {
        return this.sortTimestamp;
    }

    public void setSortTimestamp(long sortTimestamp) {
        this.sortTimestamp = sortTimestamp;
    }

    public Optional<Id<ContactV8>> getContactId() {
        return Optional.ofNullable(this.fkContact).map(AbstractTableGenerated::getItemId);
    }

    public void setContact(Optional<ContactV8> fkContact) {
        this.fkContact = fkContact.orElse(null);
    }

    public Optional<Id<PreContactV8>> getPreContactId() {
        return Optional.ofNullable(this.fkPreContact).map(AbstractTableGenerated::getItemId);
    }

    public void setPreContact(Optional<PreContactV8> fkPreContact) {
        this.fkPreContact = fkPreContact.orElse(null);
    }

    public Optional<Id<GroupV8>> getGroupId() {
        return Optional.ofNullable(this.fkGroup).map(AbstractTableGenerated::getItemId);
    }

    public void setGroup(Optional<GroupV8> fkGroup) {
        this.fkGroup = fkGroup.orElse(null);
    }

    public Optional<Id<PreGroupV8>> getPreGroupId() {
        return Optional.ofNullable(this.fkPreGroup).map(AbstractTableGenerated::getItemId);
    }

    public void setPreGroup(Optional<PreGroupV8> fkPreGroup) {
        this.fkPreGroup = fkPreGroup.orElse(null);
    }

    public boolean isUnread() {
        return this.unread;
    }

    public String toString() {
        return String.format("Discussion[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        DiscussionV8 casted = this.getClazz().cast(obj);
        return Arrays.equals(this.bytesDiscussionIdentifier, casted.bytesDiscussionIdentifier) && Objects.equals(this.lockedTitle, casted.lockedTitle) && Objects.equals(this.fkOwnedIdentity, casted.fkOwnedIdentity) && this.status == casted.status && Objects.equals(this.senderThreadIdentifier, casted.senderThreadIdentifier) && this.lastOutboundMessageSequenceNumber == casted.lastOutboundMessageSequenceNumber && Objects.equals(this.fkLastUserMessageRef, casted.fkLastUserMessageRef) && Objects.equals(this.fkLastSystemMessage, casted.fkLastSystemMessage) && this.sortTimestamp == casted.sortTimestamp && Objects.equals(this.fkContact, casted.fkContact) && Objects.equals(this.fkPreContact, casted.fkPreContact) && Objects.equals(this.fkGroup, casted.fkGroup) && Objects.equals(this.fkPreGroup, casted.fkPreGroup) && this.unread == casted.unread;
    }

    @Override
    protected Class<DiscussionV8> getClazz() {
        return DiscussionV8.class;
    }

    public static enum Status implements IComparable<Status>
    {
        PRE_DISCUSSION,
        NORMAL,
        HIDDEN,
        LOCKED;

    }
}

