/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v7;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v7.ContactRefV7;
import io.olvid.windows.messenger.database.migrations.gen.v7.OwnedIdentityV7;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.Objects;
import java.util.Optional;

@DatabaseTable(tableName="identity_ref_table")
public class IdentityRefV7
extends AbstractTableGenerated<IdentityRefV7>
implements Table {
    public static final String TABLE_NAME = "identity_ref_table";
    private static final String FK_OWNED_IDENTITY_NAME = "fk_owned_identity";
    public static final Column.ForeignColumn<IdentityRefV7, OwnedIdentityV7> FK_OWNED_IDENTITY = new Column.ForeignColumn("fk_owned_identity", true);
    private static final String FK_CONTACT_REF_NAME = "fk_contact_ref";
    public static final Column.ForeignColumn<IdentityRefV7, ContactRefV7> FK_CONTACT_REF = new Column.ForeignColumn("fk_contact_ref", true);
    @DatabaseField(columnName="fk_owned_identity", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_owned_identity UNIQUE REFERENCES owned_identity_table(gen_id) ON DELETE CASCADE")
    protected OwnedIdentityV7 fkOwnedIdentity;
    @DatabaseField(columnName="fk_contact_ref", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_contact_ref UNIQUE REFERENCES contact_ref_table(gen_id) ON DELETE CASCADE")
    protected ContactRefV7 fkContactRef;

    public IdentityRefV7() {
    }

    public IdentityRefV7(long genId) {
        super(genId);
    }

    public IdentityRefV7(long genId, OwnedIdentityV7 ownedIdentity, ContactRefV7 contactRef) {
        super(genId);
        this.fkOwnedIdentity = ownedIdentity;
        this.fkContactRef = contactRef;
    }

    public Optional<Id<OwnedIdentityV7>> getOwnedIdentityId() {
        return Optional.ofNullable(this.fkOwnedIdentity).map(AbstractTableGenerated::getItemId);
    }

    public Optional<Id<ContactRefV7>> getContactRefId() {
        return Optional.ofNullable(this.fkContactRef).map(AbstractTableGenerated::getItemId);
    }

    public String toString() {
        return String.format("IdentityRef[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        IdentityRefV7 casted = this.getClazz().cast(obj);
        return Objects.equals(this.fkOwnedIdentity, casted.fkOwnedIdentity) && Objects.equals(this.fkContactRef, casted.fkContactRef);
    }

    @Override
    protected Class<IdentityRefV7> getClazz() {
        return IdentityRefV7.class;
    }
}

