/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v6;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.fx.misc.IComparable;
import java.util.Objects;
import java.util.Optional;

@DatabaseTable(tableName="location_table")
public class LocationV6
extends AbstractTableGenerated<LocationV6>
implements Table {
    public static final String TABLE_NAME = "location_table";
    private static final String TYPE_NAME = "type";
    public static final Column.ObjectColumn<LocationV6, Type> TYPE = new Column.ObjectColumn("type", false);
    private static final String TIMESTAMP_NAME = "timestamp";
    public static final Column.longColumn<LocationV6> TIMESTAMP = new Column.longColumn("timestamp");
    private static final String COUNT_NAME = "count";
    public static final Column.ObjectColumn<LocationV6, Long> COUNT = new Column.ObjectColumn("count", true);
    private static final String SHARING_INTERVAL_NAME = "sharing_interval";
    public static final Column.ObjectColumn<LocationV6, Long> SHARING_INTERVAL = new Column.ObjectColumn("sharing_interval", true);
    private static final String SHARING_EXPIRATION_NAME = "sharing_expiration";
    public static final Column.ObjectColumn<LocationV6, Long> SHARING_EXPIRATION = new Column.ObjectColumn("sharing_expiration", true);
    private static final String LATITUDE_NAME = "latitude";
    public static final Column.doubleColumn<LocationV6> LATITUDE = new Column.doubleColumn("latitude");
    private static final String LONGITUDE_NAME = "longitude";
    public static final Column.doubleColumn<LocationV6> LONGITUDE = new Column.doubleColumn("longitude");
    private static final String ALTITUDE_NAME = "altitude";
    public static final Column.ObjectColumn<LocationV6, Double> ALTITUDE = new Column.ObjectColumn("altitude", true);
    private static final String PRECISION_NAME = "precision";
    public static final Column.ObjectColumn<LocationV6, Float> PRECISION = new Column.ObjectColumn("precision", true);
    private static final String ADDRESS_NAME = "address";
    public static final Column.ObjectColumn<LocationV6, String> ADDRESS = new Column.ObjectColumn("address", true);
    @DatabaseField(columnName="type", canBeNull=false, dataType=DataType.ENUM_NAME)
    protected Type type;
    @DatabaseField(columnName="timestamp", dataType=DataType.LONG)
    protected long timestamp;
    @DatabaseField(columnName="count", dataType=DataType.LONG_OBJ)
    protected Long count;
    @DatabaseField(columnName="sharing_interval", dataType=DataType.LONG_OBJ)
    protected Long sharingInterval;
    @DatabaseField(columnName="sharing_expiration", dataType=DataType.LONG_OBJ)
    protected Long sharingExpiration;
    @DatabaseField(columnName="latitude", dataType=DataType.DOUBLE)
    protected double latitude;
    @DatabaseField(columnName="longitude", dataType=DataType.DOUBLE)
    protected double longitude;
    @DatabaseField(columnName="altitude", dataType=DataType.DOUBLE_OBJ)
    protected Double altitude;
    @DatabaseField(columnName="precision", dataType=DataType.FLOAT_OBJ)
    protected Float precision;
    @DatabaseField(columnName="address", dataType=DataType.STRING)
    protected String address;

    public LocationV6() {
    }

    public LocationV6(long genId) {
        super(genId);
    }

    public LocationV6(long genId, Type type, long timestamp, Long count, Long sharingInterval, Long sharingExpiration, double latitude, double longitude, Double altitude, Float precision, String address) {
        super(genId);
        this.type = type;
        this.timestamp = timestamp;
        this.count = count;
        this.sharingInterval = sharingInterval;
        this.sharingExpiration = sharingExpiration;
        this.latitude = latitude;
        this.longitude = longitude;
        this.altitude = altitude;
        this.precision = precision;
        this.address = address;
    }

    public Type getType() {
        return this.type;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Optional<Long> getCount() {
        return Optional.ofNullable(this.count);
    }

    public Optional<Long> getSharingInterval() {
        return Optional.ofNullable(this.sharingInterval);
    }

    public Optional<Long> getSharingExpiration() {
        return Optional.ofNullable(this.sharingExpiration);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public Optional<Double> getAltitude() {
        return Optional.ofNullable(this.altitude);
    }

    public Optional<Float> getPrecision() {
        return Optional.ofNullable(this.precision);
    }

    public Optional<String> getAddress() {
        return Optional.ofNullable(this.address);
    }

    public String toString() {
        return String.format("Location[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        LocationV6 casted = this.getClazz().cast(obj);
        return this.type == casted.type && this.timestamp == casted.timestamp && Objects.equals(this.count, casted.count) && Objects.equals(this.sharingInterval, casted.sharingInterval) && Objects.equals(this.sharingExpiration, casted.sharingExpiration) && this.latitude == casted.latitude && this.longitude == casted.longitude && Objects.equals(this.altitude, casted.altitude) && Objects.equals(this.precision, casted.precision) && Objects.equals(this.address, casted.address);
    }

    @Override
    protected Class<LocationV6> getClazz() {
        return LocationV6.class;
    }

    public static enum Type implements IComparable<Type>
    {
        SEND,
        SHARE,
        SHARE_FINISHED;

    }
}

