/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v6;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v6.ContactV6;
import io.olvid.windows.messenger.database.migrations.gen.v6.OwnedIdentityV6;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

@DatabaseTable(tableName="contact_ref_table")
public class ContactRefV6
extends AbstractTableGenerated<ContactRefV6>
implements Table {
    public static final String TABLE_NAME = "contact_ref_table";
    private static final String FK_OWNED_IDENTITY_NAME = "fk_owned_identity";
    public static final Column.ForeignColumn<ContactRefV6, OwnedIdentityV6> FK_OWNED_IDENTITY = new Column.ForeignColumn("fk_owned_identity", false);
    private static final String BYTES_CONTACT_IDENTITY_NAME = "bytes_contact_identity";
    public static final Column.ObjectColumn<ContactRefV6, byte[]> BYTES_CONTACT_IDENTITY = new Column.ObjectColumn("bytes_contact_identity", false);
    private static final String FK_CONTACT_NAME = "fk_contact";
    public static final Column.ForeignColumn<ContactRefV6, ContactV6> FK_CONTACT = new Column.ForeignColumn("fk_contact", true);
    @DatabaseField(columnName="fk_owned_identity", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_owned_identity NOT NULL REFERENCES owned_identity_table(gen_id) ON DELETE CASCADE")
    protected OwnedIdentityV6 fkOwnedIdentity;
    @DatabaseField(columnName="bytes_contact_identity", uniqueCombo=true, canBeNull=false, dataType=DataType.BYTE_ARRAY)
    protected byte[] bytesContactIdentity;
    @DatabaseField(columnName="fk_contact", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_contact UNIQUE REFERENCES contact_table(gen_id) ON DELETE SET NULL")
    protected ContactV6 fkContact;

    public ContactRefV6() {
    }

    public ContactRefV6(long genId) {
        super(genId);
    }

    public ContactRefV6(long genId, OwnedIdentityV6 ownedIdentity, byte[] bytesContactIdentity, ContactV6 contact) {
        super(genId);
        this.fkOwnedIdentity = ownedIdentity;
        this.bytesContactIdentity = bytesContactIdentity;
        this.fkContact = contact;
    }

    public Id<OwnedIdentityV6> getOwnedIdentityId() {
        return this.fkOwnedIdentity.getItemId();
    }

    public byte[] getBytesContactIdentity() {
        return this.bytesContactIdentity;
    }

    public Optional<Id<ContactV6>> getContactId() {
        return Optional.ofNullable(this.fkContact).map(AbstractTableGenerated::getItemId);
    }

    public String toString() {
        return String.format("ContactRef[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        ContactRefV6 casted = this.getClazz().cast(obj);
        return Objects.equals(this.fkOwnedIdentity, casted.fkOwnedIdentity) && Arrays.equals(this.bytesContactIdentity, casted.bytesContactIdentity) && Objects.equals(this.fkContact, casted.fkContact);
    }

    @Override
    protected Class<ContactRefV6> getClazz() {
        return ContactRefV6.class;
    }
}

