/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v5.message;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v5.IdentityRefV5;
import io.olvid.windows.messenger.database.migrations.gen.v5.message.OutboundMessageV5;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

@DatabaseTable(tableName="message_recipient_info_table")
public class MessageRecipientInfoV5
extends AbstractTableGenerated<MessageRecipientInfoV5>
implements Table {
    public static final String TABLE_NAME = "message_recipient_info_table";
    private static final String FK_MESSAGE_NAME = "fk_message";
    public static final Column.ForeignColumn<MessageRecipientInfoV5, OutboundMessageV5> FK_MESSAGE = new Column.ForeignColumn("fk_message", false);
    private static final String FK_RECIPIENT_REF_NAME = "fk_recipient_ref";
    public static final Column.ForeignColumn<MessageRecipientInfoV5, IdentityRefV5> FK_RECIPIENT_REF = new Column.ForeignColumn("fk_recipient_ref", false);
    private static final String RETURN_RECEIPT_NONCE_NAME = "return_receipt_nonce";
    public static final Column.ObjectColumn<MessageRecipientInfoV5, byte[]> RETURN_RECEIPT_NONCE = new Column.ObjectColumn("return_receipt_nonce", false);
    private static final String RETURN_RECEIPT_KEY_NAME = "return_receipt_key";
    public static final Column.ObjectColumn<MessageRecipientInfoV5, byte[]> RETURN_RECEIPT_KEY = new Column.ObjectColumn("return_receipt_key", false);
    private static final String ENGINE_MESSAGE_IDENTIFIER_NAME = "engine_message_identifier";
    public static final Column.ObjectColumn<MessageRecipientInfoV5, byte[]> ENGINE_MESSAGE_IDENTIFIER = new Column.ObjectColumn("engine_message_identifier", false);
    private static final String TIMESTAMP_SENT_NAME = "timestamp_sent";
    public static final Column.ObjectColumn<MessageRecipientInfoV5, Long> TIMESTAMP_SENT = new Column.ObjectColumn("timestamp_sent", true);
    private static final String TIMESTAMP_DELIVERED_NAME = "timestamp_delivered";
    public static final Column.ObjectColumn<MessageRecipientInfoV5, Long> TIMESTAMP_DELIVERED = new Column.ObjectColumn("timestamp_delivered", true);
    private static final String TIMESTAMP_READ_NAME = "timestamp_read";
    public static final Column.ObjectColumn<MessageRecipientInfoV5, Long> TIMESTAMP_READ = new Column.ObjectColumn("timestamp_read", true);
    @DatabaseField(columnName="fk_message", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_message NOT NULL REFERENCES outbound_message_table(gen_id) ON DELETE CASCADE")
    protected OutboundMessageV5 fkMessage;
    @DatabaseField(columnName="fk_recipient_ref", uniqueCombo=true, foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_recipient_ref NOT NULL REFERENCES identity_ref_table(gen_id)")
    protected IdentityRefV5 fkRecipientRef;
    @DatabaseField(columnName="return_receipt_nonce", canBeNull=false, dataType=DataType.BYTE_ARRAY)
    protected byte[] returnReceiptNonce;
    @DatabaseField(columnName="return_receipt_key", canBeNull=false, dataType=DataType.BYTE_ARRAY)
    protected byte[] returnReceiptKey;
    @DatabaseField(columnName="engine_message_identifier", canBeNull=false, dataType=DataType.BYTE_ARRAY)
    protected byte[] engineMessageIdentifier;
    @DatabaseField(columnName="timestamp_sent", dataType=DataType.LONG_OBJ)
    protected Long timestampSent;
    @DatabaseField(columnName="timestamp_delivered", dataType=DataType.LONG_OBJ)
    protected Long timestampDelivered;
    @DatabaseField(columnName="timestamp_read", dataType=DataType.LONG_OBJ)
    protected Long timestampRead;

    public MessageRecipientInfoV5() {
    }

    public MessageRecipientInfoV5(long genId) {
        super(genId);
    }

    public MessageRecipientInfoV5(long genId, OutboundMessageV5 message, IdentityRefV5 recipientRef, byte[] returnReceiptNonce, byte[] returnReceiptKey, byte[] engineMessageIdentifier, Long timestampSent, Long timestampDelivered, Long timestampRead) {
        super(genId);
        this.fkMessage = message;
        this.fkRecipientRef = recipientRef;
        this.returnReceiptNonce = returnReceiptNonce;
        this.returnReceiptKey = returnReceiptKey;
        this.engineMessageIdentifier = engineMessageIdentifier;
        this.timestampSent = timestampSent;
        this.timestampDelivered = timestampDelivered;
        this.timestampRead = timestampRead;
    }

    public Id<OutboundMessageV5> getMessageId() {
        return this.fkMessage.getItemId();
    }

    public Id<IdentityRefV5> getRecipientRefId() {
        return this.fkRecipientRef.getItemId();
    }

    public byte[] getReturnReceiptNonce() {
        return this.returnReceiptNonce;
    }

    public byte[] getReturnReceiptKey() {
        return this.returnReceiptKey;
    }

    public byte[] getEngineMessageIdentifier() {
        return this.engineMessageIdentifier;
    }

    public Optional<Long> getTimestampSent() {
        return Optional.ofNullable(this.timestampSent);
    }

    public void setTimestampSent(Optional<Long> timestampSent) {
        this.timestampSent = timestampSent.orElse(null);
    }

    public Optional<Long> getTimestampDelivered() {
        return Optional.ofNullable(this.timestampDelivered);
    }

    public void setTimestampDelivered(Optional<Long> timestampDelivered) {
        this.timestampDelivered = timestampDelivered.orElse(null);
    }

    public Optional<Long> getTimestampRead() {
        return Optional.ofNullable(this.timestampRead);
    }

    public void setTimestampRead(Optional<Long> timestampRead) {
        this.timestampRead = timestampRead.orElse(null);
    }

    public String toString() {
        return String.format("MessageRecipientInfo[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        MessageRecipientInfoV5 casted = this.getClazz().cast(obj);
        return Objects.equals(this.fkMessage, casted.fkMessage) && Objects.equals(this.fkRecipientRef, casted.fkRecipientRef) && Arrays.equals(this.returnReceiptNonce, casted.returnReceiptNonce) && Arrays.equals(this.returnReceiptKey, casted.returnReceiptKey) && Arrays.equals(this.engineMessageIdentifier, casted.engineMessageIdentifier) && Objects.equals(this.timestampSent, casted.timestampSent) && Objects.equals(this.timestampDelivered, casted.timestampDelivered) && Objects.equals(this.timestampRead, casted.timestampRead);
    }

    @Override
    protected Class<MessageRecipientInfoV5> getClazz() {
        return MessageRecipientInfoV5.class;
    }
}

