/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v5.message;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v5.ContactRefV5;
import io.olvid.windows.messenger.database.migrations.gen.v5.DiscussionV5;
import io.olvid.windows.messenger.database.migrations.gen.v5.LocationV5;
import io.olvid.windows.messenger.database.migrations.gen.v5.ephemerality.InboundMessageEphemeralInfoV5;
import io.olvid.windows.messenger.database.migrations.gen.v5.message.AbstractUserMessageV5;
import io.olvid.windows.messenger.database.migrations.gen.v5.message.MessageRefV5;
import io.olvid.windows.messenger.database.migrations.gen.v5.message.ReceivedMessageV5;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.fx.misc.IComparable;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@DatabaseTable(tableName="inbound_message_table")
public class InboundMessageV5
extends ReceivedMessageV5<InboundMessageV5>
implements Table {
    public static final String TABLE_NAME = "inbound_message_table";
    private static final String FK_INBOUND_MESSAGE_EPHEMERAL_INFO_NAME = "fk_inbound_message_ephemeral_info";
    public static final Column.ForeignColumn<InboundMessageV5, InboundMessageEphemeralInfoV5> FK_INBOUND_MESSAGE_EPHEMERAL_INFO = new Column.ForeignColumn("fk_inbound_message_ephemeral_info", true);
    private static final String FK_SENDER_NAME = "fk_sender";
    public static final Column.ForeignColumn<InboundMessageV5, ContactRefV5> FK_SENDER = new Column.ForeignColumn("fk_sender", false);
    private static final String STATUS_NAME = "status";
    public static final Column.ObjectColumn<InboundMessageV5, Status> STATUS = new Column.ObjectColumn("status", false);
    private static final String BOXED_NAME = "boxed";
    public static final Column.booleanColumn<InboundMessageV5> BOXED = new Column.booleanColumn("boxed");
    @DatabaseField(columnName="fk_inbound_message_ephemeral_info", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_inbound_message_ephemeral_info REFERENCES inbound_message_ephemeral_info_table(gen_id) ON DELETE SET NULL")
    protected InboundMessageEphemeralInfoV5 fkInboundMessageEphemeralInfo;
    @DatabaseField(columnName="fk_sender", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_sender NOT NULL REFERENCES contact_ref_table(gen_id)")
    protected ContactRefV5 fkSender;
    @DatabaseField(columnName="status", index=true, canBeNull=false, dataType=DataType.ENUM_NAME)
    protected Status status;
    @DatabaseField(columnName="boxed", dataType=DataType.BOOLEAN)
    protected boolean boxed;

    public InboundMessageV5() {
    }

    public InboundMessageV5(long genId) {
        super(genId);
    }

    public InboundMessageV5(long genId, DiscussionV5 discussion, long senderSequenceNumber, double sortIndex, long timestamp, String body, MessageRefV5 replyTo, LocationV5 location, AbstractUserMessageV5.WipeStatus wipeStatus, UUID senderThreadIdentifier, int totalAttachmentCount, int imageCount, AbstractUserMessageV5.LinkPreviewKind linkPreviewKind, String linkPreviewDescription, Double linkPreviewImageWidth, AbstractUserMessageV5.EditionStatus editionStatus, boolean forwarded, byte[] returnReceiptNonce, byte[] returnReceiptKey, byte[] engineMessageIdentifier, InboundMessageEphemeralInfoV5 inboundMessageEphemeralInfo, ContactRefV5 sender, Status status, boolean boxed) {
        super(genId, discussion, senderSequenceNumber, sortIndex, timestamp, body, replyTo, location, wipeStatus, senderThreadIdentifier, totalAttachmentCount, imageCount, linkPreviewKind, linkPreviewDescription, linkPreviewImageWidth, editionStatus, forwarded, returnReceiptNonce, returnReceiptKey, engineMessageIdentifier);
        this.fkInboundMessageEphemeralInfo = inboundMessageEphemeralInfo;
        this.fkSender = sender;
        this.status = status;
        this.boxed = boxed;
    }

    public Optional<Id<InboundMessageEphemeralInfoV5>> getInboundMessageEphemeralInfoId() {
        return Optional.ofNullable(this.fkInboundMessageEphemeralInfo).map(AbstractTableGenerated::getItemId);
    }

    public Id<ContactRefV5> getSenderId() {
        return this.fkSender.getItemId();
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public boolean isBoxed() {
        return this.boxed;
    }

    public void setBoxed(boolean boxed) {
        this.boxed = boxed;
    }

    @Override
    public String toString() {
        return String.format("InboundMessage[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        InboundMessageV5 casted = this.getClazz().cast(obj);
        return super.areContentTheSame(obj) && Objects.equals(this.fkInboundMessageEphemeralInfo, casted.fkInboundMessageEphemeralInfo) && Objects.equals(this.fkSender, casted.fkSender) && this.status == casted.status && this.boxed == casted.boxed;
    }

    @Override
    protected Class<InboundMessageV5> getClazz() {
        return InboundMessageV5.class;
    }

    public static enum Status implements IComparable<Status>
    {
        UNREAD,
        READ;

    }
}

