/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v5.message;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v5.DiscussionV5;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.Objects;

public abstract class AbstractMessageV5<T extends AbstractMessageV5<T>>
extends AbstractTableGenerated<T>
implements Table {
    private static final String FK_DISCUSSION_NAME = "fk_discussion";
    public static final Column.ForeignColumn<AbstractMessageV5<?>, DiscussionV5> FK_DISCUSSION = new Column.ForeignColumn("fk_discussion", false);
    private static final String SENDER_SEQUENCE_NUMBER_NAME = "sender_sequence_number";
    public static final Column.longColumn<AbstractMessageV5<?>> SENDER_SEQUENCE_NUMBER = new Column.longColumn("sender_sequence_number");
    private static final String SORT_INDEX_NAME = "sort_index";
    public static final Column.doubleColumn<AbstractMessageV5<?>> SORT_INDEX = new Column.doubleColumn("sort_index");
    private static final String TIMESTAMP_NAME = "timestamp";
    public static final Column.longColumn<AbstractMessageV5<?>> TIMESTAMP = new Column.longColumn("timestamp");
    @DatabaseField(columnName="fk_discussion", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_discussion NOT NULL REFERENCES discussion_table(gen_id) ON DELETE CASCADE")
    protected DiscussionV5 fkDiscussion;
    @DatabaseField(columnName="sender_sequence_number", index=true, dataType=DataType.LONG)
    protected long senderSequenceNumber;
    @DatabaseField(columnName="sort_index", index=true, dataType=DataType.DOUBLE)
    protected double sortIndex;
    @DatabaseField(columnName="timestamp", dataType=DataType.LONG)
    protected long timestamp;

    public AbstractMessageV5() {
    }

    protected AbstractMessageV5(long genId) {
        super(genId);
    }

    protected AbstractMessageV5(long genId, DiscussionV5 discussion, long senderSequenceNumber, double sortIndex, long timestamp) {
        super(genId);
        this.fkDiscussion = discussion;
        this.senderSequenceNumber = senderSequenceNumber;
        this.sortIndex = sortIndex;
        this.timestamp = timestamp;
    }

    public Id<DiscussionV5> getDiscussionId() {
        return this.fkDiscussion.getItemId();
    }

    public long getSenderSequenceNumber() {
        return this.senderSequenceNumber;
    }

    public double getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(double sortIndex) {
        this.sortIndex = sortIndex;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String toString() {
        return String.format("AbstractMessage[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        AbstractMessageV5 casted = (AbstractMessageV5)this.getClazz().cast(obj);
        return Objects.equals(this.fkDiscussion, casted.fkDiscussion) && this.senderSequenceNumber == casted.senderSequenceNumber && this.sortIndex == casted.sortIndex && this.timestamp == casted.timestamp;
    }
}

