/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v5;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v5.ContactRefV5;
import io.olvid.windows.messenger.database.migrations.gen.v5.OwnedIdentityV5;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.Objects;
import java.util.Optional;

@DatabaseTable(tableName="identity_ref_table")
public class IdentityRefV5
extends AbstractTableGenerated<IdentityRefV5>
implements Table {
    public static final String TABLE_NAME = "identity_ref_table";
    private static final String FK_OWNED_IDENTITY_NAME = "fk_owned_identity";
    public static final Column.ForeignColumn<IdentityRefV5, OwnedIdentityV5> FK_OWNED_IDENTITY = new Column.ForeignColumn("fk_owned_identity", true);
    private static final String FK_CONTACT_REF_NAME = "fk_contact_ref";
    public static final Column.ForeignColumn<IdentityRefV5, ContactRefV5> FK_CONTACT_REF = new Column.ForeignColumn("fk_contact_ref", true);
    @DatabaseField(columnName="fk_owned_identity", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_owned_identity UNIQUE REFERENCES owned_identity_table(gen_id) ON DELETE CASCADE")
    protected OwnedIdentityV5 fkOwnedIdentity;
    @DatabaseField(columnName="fk_contact_ref", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_contact_ref UNIQUE REFERENCES contact_ref_table(gen_id) ON DELETE CASCADE")
    protected ContactRefV5 fkContactRef;

    public IdentityRefV5() {
    }

    public IdentityRefV5(long genId) {
        super(genId);
    }

    public IdentityRefV5(long genId, OwnedIdentityV5 ownedIdentity, ContactRefV5 contactRef) {
        super(genId);
        this.fkOwnedIdentity = ownedIdentity;
        this.fkContactRef = contactRef;
    }

    public Optional<Id<OwnedIdentityV5>> getOwnedIdentityId() {
        return Optional.ofNullable(this.fkOwnedIdentity).map(AbstractTableGenerated::getItemId);
    }

    public Optional<Id<ContactRefV5>> getContactRefId() {
        return Optional.ofNullable(this.fkContactRef).map(AbstractTableGenerated::getItemId);
    }

    public String toString() {
        return String.format("IdentityRef[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        IdentityRefV5 casted = this.getClazz().cast(obj);
        return Objects.equals(this.fkOwnedIdentity, casted.fkOwnedIdentity) && Objects.equals(this.fkContactRef, casted.fkContactRef);
    }

    @Override
    protected Class<IdentityRefV5> getClazz() {
        return IdentityRefV5.class;
    }
}

