/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v3;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v3.ContactRefV3;
import io.olvid.windows.messenger.database.migrations.gen.v3.OwnedIdentityV3;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.Objects;
import java.util.Optional;

@DatabaseTable(tableName="identity_ref_table")
public class IdentityRefV3
extends AbstractTableGenerated<IdentityRefV3>
implements Table {
    public static final String TABLE_NAME = "identity_ref_table";
    private static final String FK_OWNED_IDENTITY_NAME = "fk_owned_identity";
    public static final Column.ForeignColumn<IdentityRefV3, OwnedIdentityV3> FK_OWNED_IDENTITY = new Column.ForeignColumn("fk_owned_identity", true);
    private static final String FK_CONTACT_REF_NAME = "fk_contact_ref";
    public static final Column.ForeignColumn<IdentityRefV3, ContactRefV3> FK_CONTACT_REF = new Column.ForeignColumn("fk_contact_ref", true);
    @DatabaseField(columnName="fk_owned_identity", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_owned_identity UNIQUE REFERENCES owned_identity_table(gen_id) ON DELETE CASCADE")
    protected OwnedIdentityV3 fkOwnedIdentity;
    @DatabaseField(columnName="fk_contact_ref", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_contact_ref UNIQUE REFERENCES contact_ref_table(gen_id) ON DELETE CASCADE")
    protected ContactRefV3 fkContactRef;

    public IdentityRefV3() {
    }

    public IdentityRefV3(long genId) {
        super(genId);
    }

    public IdentityRefV3(long genId, OwnedIdentityV3 ownedIdentity, ContactRefV3 contactRef) {
        super(genId);
        this.fkOwnedIdentity = ownedIdentity;
        this.fkContactRef = contactRef;
    }

    public Optional<Id<OwnedIdentityV3>> getOwnedIdentityId() {
        return Optional.ofNullable(this.fkOwnedIdentity).map(AbstractTableGenerated::getItemId);
    }

    public Optional<Id<ContactRefV3>> getContactRefId() {
        return Optional.ofNullable(this.fkContactRef).map(AbstractTableGenerated::getItemId);
    }

    public String toString() {
        return String.format("IdentityRef[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        IdentityRefV3 casted = this.getClazz().cast(obj);
        return Objects.equals(this.fkOwnedIdentity, casted.fkOwnedIdentity) && Objects.equals(this.fkContactRef, casted.fkContactRef);
    }

    @Override
    protected Class<IdentityRefV3> getClazz() {
        return IdentityRefV3.class;
    }
}

