/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v2.ephemerality;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractMessageEphemeralInfoV2<T extends AbstractMessageEphemeralInfoV2<T>>
extends AbstractTableGenerated<T>
implements Table {
    private static final String READ_ONCE_NAME = "read_once";
    public static final Column.booleanColumn<AbstractMessageEphemeralInfoV2<?>> READ_ONCE = new Column.booleanColumn("read_once");
    private static final String VISIBILITY_DURATION_NAME = "visibility_duration";
    public static final Column.ObjectColumn<AbstractMessageEphemeralInfoV2<?>, Long> VISIBILITY_DURATION = new Column.ObjectColumn("visibility_duration", true);
    private static final String EXISTENCE_DURATION_NAME = "existence_duration";
    public static final Column.ObjectColumn<AbstractMessageEphemeralInfoV2<?>, Long> EXISTENCE_DURATION = new Column.ObjectColumn("existence_duration", true);
    private static final String VISIBILITY_TIMESTAMP_NAME = "visibility_timestamp";
    public static final Column.ObjectColumn<AbstractMessageEphemeralInfoV2<?>, Long> VISIBILITY_TIMESTAMP = new Column.ObjectColumn("visibility_timestamp", true);
    private static final String EXISTENCE_TIMESTAMP_NAME = "existence_timestamp";
    public static final Column.ObjectColumn<AbstractMessageEphemeralInfoV2<?>, Long> EXISTENCE_TIMESTAMP = new Column.ObjectColumn("existence_timestamp", true);
    @DatabaseField(columnName="read_once", dataType=DataType.BOOLEAN)
    protected boolean readOnce;
    @DatabaseField(columnName="visibility_duration", dataType=DataType.LONG_OBJ)
    protected Long visibilityDuration;
    @DatabaseField(columnName="existence_duration", dataType=DataType.LONG_OBJ)
    protected Long existenceDuration;
    @DatabaseField(columnName="visibility_timestamp", dataType=DataType.LONG_OBJ)
    protected Long visibilityTimestamp;
    @DatabaseField(columnName="existence_timestamp", dataType=DataType.LONG_OBJ)
    protected Long existenceTimestamp;

    public AbstractMessageEphemeralInfoV2() {
    }

    protected AbstractMessageEphemeralInfoV2(long genId) {
        super(genId);
    }

    protected AbstractMessageEphemeralInfoV2(long genId, boolean readOnce, Long visibilityDuration, Long existenceDuration, Long visibilityTimestamp, Long existenceTimestamp) {
        super(genId);
        this.readOnce = readOnce;
        this.visibilityDuration = visibilityDuration;
        this.existenceDuration = existenceDuration;
        this.visibilityTimestamp = visibilityTimestamp;
        this.existenceTimestamp = existenceTimestamp;
    }

    public boolean isReadOnce() {
        return this.readOnce;
    }

    public Optional<Long> getVisibilityDuration() {
        return Optional.ofNullable(this.visibilityDuration);
    }

    public Optional<Long> getExistenceDuration() {
        return Optional.ofNullable(this.existenceDuration);
    }

    public Optional<Long> getVisibilityTimestamp() {
        return Optional.ofNullable(this.visibilityTimestamp);
    }

    public void setVisibilityTimestamp(Optional<Long> visibilityTimestamp) {
        this.visibilityTimestamp = visibilityTimestamp.orElse(null);
    }

    public Optional<Long> getExistenceTimestamp() {
        return Optional.ofNullable(this.existenceTimestamp);
    }

    public void setExistenceTimestamp(Optional<Long> existenceTimestamp) {
        this.existenceTimestamp = existenceTimestamp.orElse(null);
    }

    public String toString() {
        return String.format("AbstractMessageEphemeralInfo[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        AbstractMessageEphemeralInfoV2 casted = (AbstractMessageEphemeralInfoV2)this.getClazz().cast(obj);
        return this.readOnce == casted.readOnce && Objects.equals(this.visibilityDuration, casted.visibilityDuration) && Objects.equals(this.existenceDuration, casted.existenceDuration) && Objects.equals(this.visibilityTimestamp, casted.visibilityTimestamp) && Objects.equals(this.existenceTimestamp, casted.existenceTimestamp);
    }
}

