/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v2.attachment;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v2.DiscussionV2;
import io.olvid.windows.messenger.database.migrations.gen.v2.FyleV2;
import io.olvid.windows.messenger.database.migrations.gen.v2.OwnedIdentityV2;
import io.olvid.windows.messenger.database.migrations.gen.v2.attachment.AbstractAttachmentV2;
import io.olvid.windows.messenger.database.migrations.gen.v2.message.OutboundMessageV2;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.fx.misc.IComparable;
import java.util.Objects;
import java.util.Optional;

@DatabaseTable(tableName="outbound_attachment_table")
public class OutboundAttachmentV2
extends AbstractAttachmentV2<OutboundAttachmentV2>
implements Table {
    public static final String TABLE_NAME = "outbound_attachment_table";
    private static final String FK_MESSAGE_NAME = "fk_message";
    public static final Column.ForeignColumn<OutboundAttachmentV2, OutboundMessageV2> FK_MESSAGE = new Column.ForeignColumn("fk_message", false);
    private static final String STATUS_NAME = "status";
    public static final Column.ObjectColumn<OutboundAttachmentV2, Status> STATUS = new Column.ObjectColumn("status", false);
    private static final String UPLOAD_AVERAGE_PROGRESS_NAME = "upload_average_progress";
    public static final Column.floatColumn<OutboundAttachmentV2> UPLOAD_AVERAGE_PROGRESS = new Column.floatColumn("upload_average_progress");
    private static final String TOTAL_UPLOAD_SPEED_NAME = "total_upload_speed";
    public static final Column.floatColumn<OutboundAttachmentV2> TOTAL_UPLOAD_SPEED = new Column.floatColumn("total_upload_speed");
    private static final String MAX_UPLOAD_ETA_NAME = "max_upload_eta";
    public static final Column.ObjectColumn<OutboundAttachmentV2, Integer> MAX_UPLOAD_ETA = new Column.ObjectColumn("max_upload_eta", true);
    @DatabaseField(columnName="fk_message", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_message NOT NULL REFERENCES outbound_message_table(gen_id) ON DELETE CASCADE")
    protected OutboundMessageV2 fkMessage;
    @DatabaseField(columnName="status", canBeNull=false, dataType=DataType.ENUM_NAME)
    protected Status status;
    @DatabaseField(columnName="upload_average_progress", dataType=DataType.FLOAT)
    protected float uploadAverageProgress;
    @DatabaseField(columnName="total_upload_speed", dataType=DataType.FLOAT)
    protected float totalUploadSpeed;
    @DatabaseField(columnName="max_upload_eta", dataType=DataType.INTEGER_OBJ)
    protected Integer maxUploadEta;

    public OutboundAttachmentV2() {
    }

    public OutboundAttachmentV2(long genId) {
        super(genId);
    }

    public OutboundAttachmentV2(long genId, FyleV2 fyle, OwnedIdentityV2 ownedIdentity, DiscussionV2 discussion, long size, String filename, String mimeType, String thumbnailPath, boolean thumbnailComputationFailed, int idx, OutboundMessageV2 message, Status status, float uploadAverageProgress, float totalUploadSpeed, Integer maxUploadEta) {
        super(genId, fyle, ownedIdentity, discussion, size, filename, mimeType, thumbnailPath, thumbnailComputationFailed, idx);
        this.fkMessage = message;
        this.status = status;
        this.uploadAverageProgress = uploadAverageProgress;
        this.totalUploadSpeed = totalUploadSpeed;
        this.maxUploadEta = maxUploadEta;
    }

    public Id<OutboundMessageV2> getMessageId() {
        return this.fkMessage.getItemId();
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public float getUploadAverageProgress() {
        return this.uploadAverageProgress;
    }

    public float getTotalUploadSpeed() {
        return this.totalUploadSpeed;
    }

    public Optional<Integer> getMaxUploadEta() {
        return Optional.ofNullable(this.maxUploadEta);
    }

    @Override
    public String toString() {
        return String.format("OutboundAttachment[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        OutboundAttachmentV2 casted = this.getClazz().cast(obj);
        return super.areContentTheSame(obj) && Objects.equals(this.fkMessage, casted.fkMessage) && this.status == casted.status && this.uploadAverageProgress == casted.uploadAverageProgress && this.totalUploadSpeed == casted.totalUploadSpeed && Objects.equals(this.maxUploadEta, casted.maxUploadEta);
    }

    @Override
    protected Class<OutboundAttachmentV2> getClazz() {
        return OutboundAttachmentV2.class;
    }

    public static enum Status implements IComparable<Status>
    {
        CANCELLED,
        FAILED,
        NO_CONTACT_RECIPIENTS,
        COPYING,
        DRAFT_READY,
        UNPROCESSED,
        UPLOADING,
        UPLOADED,
        SENT,
        DELIVERED,
        READ;

    }
}

