/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v2;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

@DatabaseTable(tableName="fyle_table")
public class FyleV2
extends AbstractTableGenerated<FyleV2>
implements Table {
    public static final String TABLE_NAME = "fyle_table";
    private static final String FILE_PATH_NAME = "file_path";
    public static final Column.ObjectColumn<FyleV2, String> FILE_PATH = new Column.ObjectColumn("file_path", false);
    private static final String SHA256_NAME = "sha256";
    public static final Column.ObjectColumn<FyleV2, byte[]> SHA256 = new Column.ObjectColumn("sha256", true);
    @DatabaseField(columnName="file_path", canBeNull=false, dataType=DataType.STRING)
    protected String filePath;
    @DatabaseField(columnName="sha256", unique=true, dataType=DataType.BYTE_ARRAY)
    protected byte[] sha256;

    public FyleV2() {
    }

    public FyleV2(long genId) {
        super(genId);
    }

    public FyleV2(long genId, String filePath, byte[] sha256) {
        super(genId);
        this.filePath = filePath;
        this.sha256 = sha256;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public Optional<byte[]> getSha256() {
        return Optional.ofNullable(this.sha256);
    }

    public void setSha256(Optional<byte[]> sha256) {
        this.sha256 = sha256.orElse(null);
    }

    public String toString() {
        return String.format("Fyle[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        FyleV2 casted = this.getClazz().cast(obj);
        return Objects.equals(this.filePath, casted.filePath) && Arrays.equals(this.sha256, casted.sha256);
    }

    @Override
    protected Class<FyleV2> getClazz() {
        return FyleV2.class;
    }
}

