/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v1.metadata;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v1.IdentityRefV1;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractMessageMetadataV1<T extends AbstractMessageMetadataV1<T>>
extends AbstractTableGenerated<T>
implements Table {
    private static final String TIMESTAMP_NAME = "timestamp";
    public static final Column.longColumn<AbstractMessageMetadataV1<?>> TIMESTAMP = new Column.longColumn("timestamp");
    private static final String FK_DELETER_NAME = "fk_deleter";
    public static final Column.ForeignColumn<AbstractMessageMetadataV1<?>, IdentityRefV1> FK_DELETER = new Column.ForeignColumn("fk_deleter", true);
    @DatabaseField(columnName="timestamp", dataType=DataType.LONG)
    protected long timestamp;
    @DatabaseField(columnName="fk_deleter", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_deleter REFERENCES identity_ref_table(gen_id) ON DELETE SET NULL")
    protected IdentityRefV1 fkDeleter;

    public AbstractMessageMetadataV1() {
    }

    protected AbstractMessageMetadataV1(long genId) {
        super(genId);
    }

    protected AbstractMessageMetadataV1(long genId, long timestamp, IdentityRefV1 deleter) {
        super(genId);
        this.timestamp = timestamp;
        this.fkDeleter = deleter;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Optional<Id<IdentityRefV1>> getDeleterId() {
        return Optional.ofNullable(this.fkDeleter).map(AbstractTableGenerated::getItemId);
    }

    public String toString() {
        return String.format("AbstractMessageMetadata[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        AbstractMessageMetadataV1 casted = (AbstractMessageMetadataV1)this.getClazz().cast(obj);
        return this.timestamp == casted.timestamp && Objects.equals(this.fkDeleter, casted.fkDeleter);
    }
}

