/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v1.message;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v1.ContactRefV1;
import io.olvid.windows.messenger.database.migrations.gen.v1.DiscussionV1;
import io.olvid.windows.messenger.database.migrations.gen.v1.LocationV1;
import io.olvid.windows.messenger.database.migrations.gen.v1.ephemerality.InboundMessageEphemeralInfoV1;
import io.olvid.windows.messenger.database.migrations.gen.v1.message.AbstractUserMessageV1;
import io.olvid.windows.messenger.database.migrations.gen.v1.message.MessageRefV1;
import io.olvid.windows.messenger.database.migrations.gen.v1.message.ReceivedMessageV1;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.fx.misc.IComparable;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@DatabaseTable(tableName="inbound_message_table")
public class InboundMessageV1
extends ReceivedMessageV1<InboundMessageV1>
implements Table {
    public static final String TABLE_NAME = "inbound_message_table";
    private static final String FK_INBOUND_MESSAGE_EPHEMERAL_INFO_NAME = "fk_inbound_message_ephemeral_info";
    public static final Column.ForeignColumn<InboundMessageV1, InboundMessageEphemeralInfoV1> FK_INBOUND_MESSAGE_EPHEMERAL_INFO = new Column.ForeignColumn("fk_inbound_message_ephemeral_info", true);
    private static final String FK_SENDER_NAME = "fk_sender";
    public static final Column.ForeignColumn<InboundMessageV1, ContactRefV1> FK_SENDER = new Column.ForeignColumn("fk_sender", false);
    private static final String STATUS_NAME = "status";
    public static final Column.ObjectColumn<InboundMessageV1, Status> STATUS = new Column.ObjectColumn("status", false);
    private static final String BOXED_NAME = "boxed";
    public static final Column.booleanColumn<InboundMessageV1> BOXED = new Column.booleanColumn("boxed");
    @DatabaseField(columnName="fk_inbound_message_ephemeral_info", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_inbound_message_ephemeral_info REFERENCES inbound_message_ephemeral_info_table(gen_id) ON DELETE SET NULL")
    protected InboundMessageEphemeralInfoV1 fkInboundMessageEphemeralInfo;
    @DatabaseField(columnName="fk_sender", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_sender NOT NULL REFERENCES contact_ref_table(gen_id)")
    protected ContactRefV1 fkSender;
    @DatabaseField(columnName="status", canBeNull=false, dataType=DataType.ENUM_NAME)
    protected Status status;
    @DatabaseField(columnName="boxed", dataType=DataType.BOOLEAN)
    protected boolean boxed;

    public InboundMessageV1() {
    }

    public InboundMessageV1(long genId) {
        super(genId);
    }

    public InboundMessageV1(long genId, DiscussionV1 discussion, long senderSequenceNumber, double sortIndex, long timestamp, String body, MessageRefV1 replyTo, LocationV1 location, AbstractUserMessageV1.WipeStatus wipeStatus, UUID senderThreadIdentifier, int totalAttachmentCount, int imageCount, int wipedAttachmentCount, AbstractUserMessageV1.EditionStatus editionStatus, boolean forwarded, byte[] returnReceiptNonce, byte[] returnReceiptKey, byte[] engineMessageIdentifier, InboundMessageEphemeralInfoV1 inboundMessageEphemeralInfo, ContactRefV1 sender, Status status, boolean boxed) {
        super(genId, discussion, senderSequenceNumber, sortIndex, timestamp, body, replyTo, location, wipeStatus, senderThreadIdentifier, totalAttachmentCount, imageCount, wipedAttachmentCount, editionStatus, forwarded, returnReceiptNonce, returnReceiptKey, engineMessageIdentifier);
        this.fkInboundMessageEphemeralInfo = inboundMessageEphemeralInfo;
        this.fkSender = sender;
        this.status = status;
        this.boxed = boxed;
    }

    public Optional<Id<InboundMessageEphemeralInfoV1>> getInboundMessageEphemeralInfoId() {
        return Optional.ofNullable(this.fkInboundMessageEphemeralInfo).map(AbstractTableGenerated::getItemId);
    }

    public Id<ContactRefV1> getSenderId() {
        return this.fkSender.getItemId();
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean isBoxed() {
        return this.boxed;
    }

    public void setBoxed(boolean boxed) {
        this.boxed = boxed;
    }

    @Override
    public String toString() {
        return String.format("InboundMessage[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        InboundMessageV1 casted = this.getClazz().cast(obj);
        return super.areContentTheSame(obj) && Objects.equals(this.fkInboundMessageEphemeralInfo, casted.fkInboundMessageEphemeralInfo) && Objects.equals(this.fkSender, casted.fkSender) && this.status == casted.status && this.boxed == casted.boxed;
    }

    @Override
    protected Class<InboundMessageV1> getClazz() {
        return InboundMessageV1.class;
    }

    public static enum Status implements IComparable<Status>
    {
        UNREAD,
        READ;

    }
}

