/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.migrations.gen.v1.message;

import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.migrations.gen.v1.DiscussionV1;
import io.olvid.windows.messenger.database.migrations.gen.v1.LocationV1;
import io.olvid.windows.messenger.database.migrations.gen.v1.message.AbstractMessageV1;
import io.olvid.windows.messenger.database.migrations.gen.v1.message.MessageRefV1;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.fx.misc.IComparable;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public abstract class AbstractUserMessageV1<T extends AbstractUserMessageV1<T>>
extends AbstractMessageV1<T>
implements Table {
    private static final String BODY_NAME = "body";
    public static final Column.ObjectColumn<AbstractUserMessageV1<?>, String> BODY = new Column.ObjectColumn("body", true);
    private static final String FK_REPLY_TO_NAME = "fk_reply_to";
    public static final Column.ForeignColumn<AbstractUserMessageV1<?>, MessageRefV1> FK_REPLY_TO = new Column.ForeignColumn("fk_reply_to", true);
    private static final String FK_LOCATION_NAME = "fk_location";
    public static final Column.ForeignColumn<AbstractUserMessageV1<?>, LocationV1> FK_LOCATION = new Column.ForeignColumn("fk_location", true);
    private static final String WIPE_STATUS_NAME = "wipe_status";
    public static final Column.ObjectColumn<AbstractUserMessageV1<?>, WipeStatus> WIPE_STATUS = new Column.ObjectColumn("wipe_status", false);
    private static final String SENDER_THREAD_IDENTIFIER_NAME = "sender_thread_identifier";
    public static final Column.ObjectColumn<AbstractUserMessageV1<?>, UUID> SENDER_THREAD_IDENTIFIER = new Column.ObjectColumn("sender_thread_identifier", false);
    private static final String TOTAL_ATTACHMENT_COUNT_NAME = "total_attachment_count";
    public static final Column.intColumn<AbstractUserMessageV1<?>> TOTAL_ATTACHMENT_COUNT = new Column.intColumn("total_attachment_count");
    private static final String IMAGE_COUNT_NAME = "image_count";
    public static final Column.intColumn<AbstractUserMessageV1<?>> IMAGE_COUNT = new Column.intColumn("image_count");
    private static final String WIPED_ATTACHMENT_COUNT_NAME = "wiped_attachment_count";
    public static final Column.intColumn<AbstractUserMessageV1<?>> WIPED_ATTACHMENT_COUNT = new Column.intColumn("wiped_attachment_count");
    private static final String EDITION_STATUS_NAME = "edition_status";
    public static final Column.ObjectColumn<AbstractUserMessageV1<?>, EditionStatus> EDITION_STATUS = new Column.ObjectColumn("edition_status", false);
    private static final String FORWARDED_NAME = "forwarded";
    public static final Column.booleanColumn<AbstractUserMessageV1<?>> FORWARDED = new Column.booleanColumn("forwarded");
    @DatabaseField(columnName="body", dataType=DataType.STRING)
    protected String body;
    @DatabaseField(columnName="fk_reply_to", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_reply_to REFERENCES message_ref_table(gen_id) ON DELETE SET NULL")
    protected MessageRefV1 fkReplyTo;
    @DatabaseField(columnName="fk_location", foreign=true, index=true, columnDefinition="LONG CONSTRAINT fk_location REFERENCES location_table(gen_id) ON DELETE SET NULL")
    protected LocationV1 fkLocation;
    @DatabaseField(columnName="wipe_status", canBeNull=false, dataType=DataType.ENUM_NAME)
    protected WipeStatus wipeStatus;
    @DatabaseField(columnName="sender_thread_identifier", canBeNull=false, dataType=DataType.UUID)
    protected UUID senderThreadIdentifier;
    @DatabaseField(columnName="total_attachment_count", dataType=DataType.INTEGER)
    protected int totalAttachmentCount;
    @DatabaseField(columnName="image_count", dataType=DataType.INTEGER)
    protected int imageCount;
    @DatabaseField(columnName="wiped_attachment_count", dataType=DataType.INTEGER)
    protected int wipedAttachmentCount;
    @DatabaseField(columnName="edition_status", canBeNull=false, dataType=DataType.ENUM_NAME)
    protected EditionStatus editionStatus;
    @DatabaseField(columnName="forwarded", dataType=DataType.BOOLEAN)
    protected boolean forwarded;

    public AbstractUserMessageV1() {
    }

    protected AbstractUserMessageV1(long genId) {
        super(genId);
    }

    protected AbstractUserMessageV1(long genId, DiscussionV1 discussion, long senderSequenceNumber, double sortIndex, long timestamp, String body, MessageRefV1 replyTo, LocationV1 location, WipeStatus wipeStatus, UUID senderThreadIdentifier, int totalAttachmentCount, int imageCount, int wipedAttachmentCount, EditionStatus editionStatus, boolean forwarded) {
        super(genId, discussion, senderSequenceNumber, sortIndex, timestamp);
        this.body = body;
        this.fkReplyTo = replyTo;
        this.fkLocation = location;
        this.wipeStatus = wipeStatus;
        this.senderThreadIdentifier = senderThreadIdentifier;
        this.totalAttachmentCount = totalAttachmentCount;
        this.imageCount = imageCount;
        this.wipedAttachmentCount = wipedAttachmentCount;
        this.editionStatus = editionStatus;
        this.forwarded = forwarded;
    }

    public Optional<String> getBody() {
        return Optional.ofNullable(this.body);
    }

    public void setBody(Optional<String> body) {
        this.body = body.orElse(null);
    }

    public Optional<Id<MessageRefV1>> getReplyToId() {
        return Optional.ofNullable(this.fkReplyTo).map(AbstractTableGenerated::getItemId);
    }

    public void setReplyTo(Optional<MessageRefV1> fkReplyTo) {
        this.fkReplyTo = fkReplyTo.orElse(null);
    }

    public Optional<Id<LocationV1>> getLocationId() {
        return Optional.ofNullable(this.fkLocation).map(AbstractTableGenerated::getItemId);
    }

    public WipeStatus getWipeStatus() {
        return this.wipeStatus;
    }

    public void setWipeStatus(WipeStatus wipeStatus) {
        this.wipeStatus = wipeStatus;
    }

    public UUID getSenderThreadIdentifier() {
        return this.senderThreadIdentifier;
    }

    public int getTotalAttachmentCount() {
        return this.totalAttachmentCount;
    }

    public void setTotalAttachmentCount(int totalAttachmentCount) {
        this.totalAttachmentCount = totalAttachmentCount;
    }

    public int getImageCount() {
        return this.imageCount;
    }

    public void setImageCount(int imageCount) {
        this.imageCount = imageCount;
    }

    public int getWipedAttachmentCount() {
        return this.wipedAttachmentCount;
    }

    public void setWipedAttachmentCount(int wipedAttachmentCount) {
        this.wipedAttachmentCount = wipedAttachmentCount;
    }

    public EditionStatus getEditionStatus() {
        return this.editionStatus;
    }

    public void setEditionStatus(EditionStatus editionStatus) {
        this.editionStatus = editionStatus;
    }

    public boolean isForwarded() {
        return this.forwarded;
    }

    public void setForwarded(boolean forwarded) {
        this.forwarded = forwarded;
    }

    @Override
    public String toString() {
        return String.format("AbstractUserMessage[%s]", this.getItemId());
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        AbstractUserMessageV1 casted = (AbstractUserMessageV1)this.getClazz().cast(obj);
        return super.areContentTheSame(obj) && Objects.equals(this.body, casted.body) && Objects.equals(this.fkReplyTo, casted.fkReplyTo) && Objects.equals(this.fkLocation, casted.fkLocation) && this.wipeStatus == casted.wipeStatus && Objects.equals(this.senderThreadIdentifier, casted.senderThreadIdentifier) && this.totalAttachmentCount == casted.totalAttachmentCount && this.imageCount == casted.imageCount && this.wipedAttachmentCount == casted.wipedAttachmentCount && this.editionStatus == casted.editionStatus && this.forwarded == casted.forwarded;
    }

    public static enum WipeStatus implements IComparable<WipeStatus>
    {
        NONE,
        WIPE_ON_READ,
        WIPED,
        REMOTE_DELETED;

    }

    public static enum EditionStatus implements IComparable<EditionStatus>
    {
        NONE,
        UNSEEN,
        SEEN;

    }
}

